/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.NameValuePair;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EndpointRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="method")
    private final Method method;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="contentType")
    private final String contentType;
    @JsonProperty(value="payload")
    private final String payload;
    @JsonProperty(value="headers")
    private final List<NameValuePair> headers;
    @JsonProperty(value="formParameters")
    private final List<NameValuePair> formParameters;

    @Deprecated
    @ConstructorProperties(value={"method", "url", "contentType", "payload", "headers", "formParameters"})
    public EndpointRequest(Method method, String url, String contentType, String payload, List<NameValuePair> headers, List<NameValuePair> formParameters) {
        this.method = method;
        this.url = url;
        this.contentType = contentType;
        this.payload = payload;
        this.headers = headers;
        this.formParameters = formParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPayload() {
        return this.payload;
    }

    public List<NameValuePair> getHeaders() {
        return this.headers;
    }

    public List<NameValuePair> getFormParameters() {
        return this.formParameters;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EndpointRequest(");
        sb.append("super=").append(super.toString());
        sb.append("method=").append(String.valueOf((Object)this.method));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", contentType=").append(String.valueOf(this.contentType));
        sb.append(", payload=").append(String.valueOf(this.payload));
        sb.append(", headers=").append(String.valueOf(this.headers));
        sb.append(", formParameters=").append(String.valueOf(this.formParameters));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointRequest)) {
            return false;
        }
        EndpointRequest other = (EndpointRequest)((Object)o);
        return Objects.equals((Object)this.method, (Object)other.method) && Objects.equals(this.url, other.url) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.payload, other.payload) && Objects.equals(this.headers, other.headers) && Objects.equals(this.formParameters, other.formParameters) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.method == null ? 43 : this.method.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.payload == null ? 43 : this.payload.hashCode());
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        result = result * 59 + (this.formParameters == null ? 43 : this.formParameters.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Method implements BmcEnum
    {
        Get("GET"),
        Post("POST"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Method> map;

        private Method(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Method create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Method', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Method.class);
            map = new HashMap<String, Method>();
            for (Method v : Method.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="method")
        private Method method;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="contentType")
        private String contentType;
        @JsonProperty(value="payload")
        private String payload;
        @JsonProperty(value="headers")
        private List<NameValuePair> headers;
        @JsonProperty(value="formParameters")
        private List<NameValuePair> formParameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder method(Method method) {
            this.method = method;
            this.__explicitlySet__.add("method");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            this.__explicitlySet__.add("contentType");
            return this;
        }

        public Builder payload(String payload) {
            this.payload = payload;
            this.__explicitlySet__.add("payload");
            return this;
        }

        public Builder headers(List<NameValuePair> headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public Builder formParameters(List<NameValuePair> formParameters) {
            this.formParameters = formParameters;
            this.__explicitlySet__.add("formParameters");
            return this;
        }

        public EndpointRequest build() {
            EndpointRequest model = new EndpointRequest(this.method, this.url, this.contentType, this.payload, this.headers, this.formParameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EndpointRequest model) {
            if (model.wasPropertyExplicitlySet("method")) {
                this.method(model.getMethod());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("contentType")) {
                this.contentType(model.getContentType());
            }
            if (model.wasPropertyExplicitlySet("payload")) {
                this.payload(model.getPayload());
            }
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            if (model.wasPropertyExplicitlySet("formParameters")) {
                this.formParameters(model.getFormParameters());
            }
            return this;
        }
    }
}

