/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.UploadFileStatus;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FileValidationResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="inputFile")
    private final String inputFile;
    @JsonProperty(value="objectLocation")
    private final String objectLocation;
    @JsonProperty(value="files")
    private final List<UploadFileStatus> files;

    @Deprecated
    @ConstructorProperties(value={"inputFile", "objectLocation", "files"})
    public FileValidationResponse(String inputFile, String objectLocation, List<UploadFileStatus> files) {
        this.inputFile = inputFile;
        this.objectLocation = objectLocation;
        this.files = files;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getObjectLocation() {
        return this.objectLocation;
    }

    public List<UploadFileStatus> getFiles() {
        return this.files;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FileValidationResponse(");
        sb.append("super=").append(super.toString());
        sb.append("inputFile=").append(String.valueOf(this.inputFile));
        sb.append(", objectLocation=").append(String.valueOf(this.objectLocation));
        sb.append(", files=").append(String.valueOf(this.files));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileValidationResponse)) {
            return false;
        }
        FileValidationResponse other = (FileValidationResponse)((Object)o);
        return Objects.equals(this.inputFile, other.inputFile) && Objects.equals(this.objectLocation, other.objectLocation) && Objects.equals(this.files, other.files) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.inputFile == null ? 43 : this.inputFile.hashCode());
        result = result * 59 + (this.objectLocation == null ? 43 : this.objectLocation.hashCode());
        result = result * 59 + (this.files == null ? 43 : this.files.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="inputFile")
        private String inputFile;
        @JsonProperty(value="objectLocation")
        private String objectLocation;
        @JsonProperty(value="files")
        private List<UploadFileStatus> files;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder inputFile(String inputFile) {
            this.inputFile = inputFile;
            this.__explicitlySet__.add("inputFile");
            return this;
        }

        public Builder objectLocation(String objectLocation) {
            this.objectLocation = objectLocation;
            this.__explicitlySet__.add("objectLocation");
            return this;
        }

        public Builder files(List<UploadFileStatus> files) {
            this.files = files;
            this.__explicitlySet__.add("files");
            return this;
        }

        public FileValidationResponse build() {
            FileValidationResponse model = new FileValidationResponse(this.inputFile, this.objectLocation, this.files);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FileValidationResponse model) {
            if (model.wasPropertyExplicitlySet("inputFile")) {
                this.inputFile(model.getInputFile());
            }
            if (model.wasPropertyExplicitlySet("objectLocation")) {
                this.objectLocation(model.getObjectLocation());
            }
            if (model.wasPropertyExplicitlySet("files")) {
                this.files(model.getFiles());
            }
            return this;
        }
    }
}

