/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FilterOutput
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayQueryString")
    private final String displayQueryString;
    @JsonProperty(value="internalQueryString")
    private final String internalQueryString;
    @JsonProperty(value="responseTimeInMs")
    private final Long responseTimeInMs;

    @Deprecated
    @ConstructorProperties(value={"displayQueryString", "internalQueryString", "responseTimeInMs"})
    public FilterOutput(String displayQueryString, String internalQueryString, Long responseTimeInMs) {
        this.displayQueryString = displayQueryString;
        this.internalQueryString = internalQueryString;
        this.responseTimeInMs = responseTimeInMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayQueryString() {
        return this.displayQueryString;
    }

    public String getInternalQueryString() {
        return this.internalQueryString;
    }

    public Long getResponseTimeInMs() {
        return this.responseTimeInMs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FilterOutput(");
        sb.append("super=").append(super.toString());
        sb.append("displayQueryString=").append(String.valueOf(this.displayQueryString));
        sb.append(", internalQueryString=").append(String.valueOf(this.internalQueryString));
        sb.append(", responseTimeInMs=").append(String.valueOf(this.responseTimeInMs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterOutput)) {
            return false;
        }
        FilterOutput other = (FilterOutput)((Object)o);
        return Objects.equals(this.displayQueryString, other.displayQueryString) && Objects.equals(this.internalQueryString, other.internalQueryString) && Objects.equals(this.responseTimeInMs, other.responseTimeInMs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayQueryString == null ? 43 : this.displayQueryString.hashCode());
        result = result * 59 + (this.internalQueryString == null ? 43 : this.internalQueryString.hashCode());
        result = result * 59 + (this.responseTimeInMs == null ? 43 : this.responseTimeInMs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="responseTimeInMs")
        private Long responseTimeInMs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder responseTimeInMs(Long responseTimeInMs) {
            this.responseTimeInMs = responseTimeInMs;
            this.__explicitlySet__.add("responseTimeInMs");
            return this;
        }

        public FilterOutput build() {
            FilterOutput model = new FilterOutput(this.displayQueryString, this.internalQueryString, this.responseTimeInMs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FilterOutput model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("responseTimeInMs")) {
                this.responseTimeInMs(model.getResponseTimeInMs());
            }
            return this;
        }
    }
}

