/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsEntityTopologyLink
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sourceEntityId")
    private final String sourceEntityId;
    @JsonProperty(value="destinationEntityId")
    private final String destinationEntityId;

    @Deprecated
    @ConstructorProperties(value={"sourceEntityId", "destinationEntityId"})
    public LogAnalyticsEntityTopologyLink(String sourceEntityId, String destinationEntityId) {
        this.sourceEntityId = sourceEntityId;
        this.destinationEntityId = destinationEntityId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSourceEntityId() {
        return this.sourceEntityId;
    }

    public String getDestinationEntityId() {
        return this.destinationEntityId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsEntityTopologyLink(");
        sb.append("super=").append(super.toString());
        sb.append("sourceEntityId=").append(String.valueOf(this.sourceEntityId));
        sb.append(", destinationEntityId=").append(String.valueOf(this.destinationEntityId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsEntityTopologyLink)) {
            return false;
        }
        LogAnalyticsEntityTopologyLink other = (LogAnalyticsEntityTopologyLink)((Object)o);
        return Objects.equals(this.sourceEntityId, other.sourceEntityId) && Objects.equals(this.destinationEntityId, other.destinationEntityId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sourceEntityId == null ? 43 : this.sourceEntityId.hashCode());
        result = result * 59 + (this.destinationEntityId == null ? 43 : this.destinationEntityId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceEntityId")
        private String sourceEntityId;
        @JsonProperty(value="destinationEntityId")
        private String destinationEntityId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceEntityId(String sourceEntityId) {
            this.sourceEntityId = sourceEntityId;
            this.__explicitlySet__.add("sourceEntityId");
            return this;
        }

        public Builder destinationEntityId(String destinationEntityId) {
            this.destinationEntityId = destinationEntityId;
            this.__explicitlySet__.add("destinationEntityId");
            return this;
        }

        public LogAnalyticsEntityTopologyLink build() {
            LogAnalyticsEntityTopologyLink model = new LogAnalyticsEntityTopologyLink(this.sourceEntityId, this.destinationEntityId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsEntityTopologyLink model) {
            if (model.wasPropertyExplicitlySet("sourceEntityId")) {
                this.sourceEntityId(model.getSourceEntityId());
            }
            if (model.wasPropertyExplicitlySet("destinationEntityId")) {
                this.destinationEntityId(model.getDestinationEntityId());
            }
            return this;
        }
    }
}

