/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.LogAnalyticsLabelAlias;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsLabel
extends ExplicitlySetBmcModel {
    @JsonProperty(value="aliases")
    private final List<LogAnalyticsLabelAlias> aliases;
    @JsonProperty(value="countUsageInSource")
    private final Long countUsageInSource;
    @JsonProperty(value="suggestType")
    private final Long suggestType;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="editVersion")
    private final Long editVersion;
    @JsonProperty(value="impact")
    private final String impact;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="priority")
    private final Priority priority;
    @JsonProperty(value="recommendation")
    private final String recommendation;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="isUserDeleted")
    private final Boolean isUserDeleted;

    @Deprecated
    @ConstructorProperties(value={"aliases", "countUsageInSource", "suggestType", "description", "displayName", "editVersion", "impact", "isSystem", "name", "priority", "recommendation", "type", "isUserDeleted"})
    public LogAnalyticsLabel(List<LogAnalyticsLabelAlias> aliases, Long countUsageInSource, Long suggestType, String description, String displayName, Long editVersion, String impact, Boolean isSystem, String name, Priority priority, String recommendation, Type type, Boolean isUserDeleted) {
        this.aliases = aliases;
        this.countUsageInSource = countUsageInSource;
        this.suggestType = suggestType;
        this.description = description;
        this.displayName = displayName;
        this.editVersion = editVersion;
        this.impact = impact;
        this.isSystem = isSystem;
        this.name = name;
        this.priority = priority;
        this.recommendation = recommendation;
        this.type = type;
        this.isUserDeleted = isUserDeleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<LogAnalyticsLabelAlias> getAliases() {
        return this.aliases;
    }

    public Long getCountUsageInSource() {
        return this.countUsageInSource;
    }

    public Long getSuggestType() {
        return this.suggestType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getEditVersion() {
        return this.editVersion;
    }

    public String getImpact() {
        return this.impact;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public String getName() {
        return this.name;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getIsUserDeleted() {
        return this.isUserDeleted;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsLabel(");
        sb.append("super=").append(super.toString());
        sb.append("aliases=").append(String.valueOf(this.aliases));
        sb.append(", countUsageInSource=").append(String.valueOf(this.countUsageInSource));
        sb.append(", suggestType=").append(String.valueOf(this.suggestType));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", editVersion=").append(String.valueOf(this.editVersion));
        sb.append(", impact=").append(String.valueOf(this.impact));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", priority=").append(String.valueOf((Object)this.priority));
        sb.append(", recommendation=").append(String.valueOf(this.recommendation));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", isUserDeleted=").append(String.valueOf(this.isUserDeleted));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsLabel)) {
            return false;
        }
        LogAnalyticsLabel other = (LogAnalyticsLabel)((Object)o);
        return Objects.equals(this.aliases, other.aliases) && Objects.equals(this.countUsageInSource, other.countUsageInSource) && Objects.equals(this.suggestType, other.suggestType) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.editVersion, other.editVersion) && Objects.equals(this.impact, other.impact) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.priority, (Object)other.priority) && Objects.equals(this.recommendation, other.recommendation) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.isUserDeleted, other.isUserDeleted) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.aliases == null ? 43 : this.aliases.hashCode());
        result = result * 59 + (this.countUsageInSource == null ? 43 : this.countUsageInSource.hashCode());
        result = result * 59 + (this.suggestType == null ? 43 : this.suggestType.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.editVersion == null ? 43 : this.editVersion.hashCode());
        result = result * 59 + (this.impact == null ? 43 : this.impact.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.priority == null ? 43 : this.priority.hashCode());
        result = result * 59 + (this.recommendation == null ? 43 : this.recommendation.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.isUserDeleted == null ? 43 : this.isUserDeleted.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Info("INFO"),
        Problem("PROBLEM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Priority implements BmcEnum
    {
        None("NONE"),
        Low("LOW"),
        Medium("MEDIUM"),
        High("HIGH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Priority> map;

        private Priority(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Priority create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Priority', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Priority.class);
            map = new HashMap<String, Priority>();
            for (Priority v : Priority.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="aliases")
        private List<LogAnalyticsLabelAlias> aliases;
        @JsonProperty(value="countUsageInSource")
        private Long countUsageInSource;
        @JsonProperty(value="suggestType")
        private Long suggestType;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="editVersion")
        private Long editVersion;
        @JsonProperty(value="impact")
        private String impact;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="priority")
        private Priority priority;
        @JsonProperty(value="recommendation")
        private String recommendation;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="isUserDeleted")
        private Boolean isUserDeleted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder aliases(List<LogAnalyticsLabelAlias> aliases) {
            this.aliases = aliases;
            this.__explicitlySet__.add("aliases");
            return this;
        }

        public Builder countUsageInSource(Long countUsageInSource) {
            this.countUsageInSource = countUsageInSource;
            this.__explicitlySet__.add("countUsageInSource");
            return this;
        }

        public Builder suggestType(Long suggestType) {
            this.suggestType = suggestType;
            this.__explicitlySet__.add("suggestType");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder editVersion(Long editVersion) {
            this.editVersion = editVersion;
            this.__explicitlySet__.add("editVersion");
            return this;
        }

        public Builder impact(String impact) {
            this.impact = impact;
            this.__explicitlySet__.add("impact");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority;
            this.__explicitlySet__.add("priority");
            return this;
        }

        public Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            this.__explicitlySet__.add("recommendation");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder isUserDeleted(Boolean isUserDeleted) {
            this.isUserDeleted = isUserDeleted;
            this.__explicitlySet__.add("isUserDeleted");
            return this;
        }

        public LogAnalyticsLabel build() {
            LogAnalyticsLabel model = new LogAnalyticsLabel(this.aliases, this.countUsageInSource, this.suggestType, this.description, this.displayName, this.editVersion, this.impact, this.isSystem, this.name, this.priority, this.recommendation, this.type, this.isUserDeleted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsLabel model) {
            if (model.wasPropertyExplicitlySet("aliases")) {
                this.aliases(model.getAliases());
            }
            if (model.wasPropertyExplicitlySet("countUsageInSource")) {
                this.countUsageInSource(model.getCountUsageInSource());
            }
            if (model.wasPropertyExplicitlySet("suggestType")) {
                this.suggestType(model.getSuggestType());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("editVersion")) {
                this.editVersion(model.getEditVersion());
            }
            if (model.wasPropertyExplicitlySet("impact")) {
                this.impact(model.getImpact());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("priority")) {
                this.priority(model.getPriority());
            }
            if (model.wasPropertyExplicitlySet("recommendation")) {
                this.recommendation(model.getRecommendation());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("isUserDeleted")) {
                this.isUserDeleted(model.getIsUserDeleted());
            }
            return this;
        }
    }
}

