/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSource;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsMetric
extends ExplicitlySetBmcModel {
    @JsonProperty(value="aggregationField")
    private final String aggregationField;
    @JsonProperty(value="bucketMetadata")
    private final String bucketMetadata;
    @JsonProperty(value="clockPeriod")
    private final String clockPeriod;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="editVersion")
    private final Long editVersion;
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="fieldValues")
    private final List<String> fieldValues;
    @JsonProperty(value="groupingField")
    private final String groupingField;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="metricReference")
    private final Long metricReference;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="metricType")
    private final MetricType metricType;
    @JsonProperty(value="isMetricSourceEnabled")
    private final Boolean isMetricSourceEnabled;
    @JsonProperty(value="operator")
    private final Operator operator;
    @JsonProperty(value="sources")
    private final List<LogAnalyticsSource> sources;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="unitType")
    private final String unitType;
    @JsonProperty(value="isUserCustomized")
    private final Boolean isUserCustomized;

    @Deprecated
    @ConstructorProperties(value={"aggregationField", "bucketMetadata", "clockPeriod", "description", "editVersion", "fieldName", "fieldValues", "groupingField", "isEnabled", "isSystem", "displayName", "metricReference", "name", "metricType", "isMetricSourceEnabled", "operator", "sources", "entityType", "timeUpdated", "unitType", "isUserCustomized"})
    public LogAnalyticsMetric(String aggregationField, String bucketMetadata, String clockPeriod, String description, Long editVersion, String fieldName, List<String> fieldValues, String groupingField, Boolean isEnabled, Boolean isSystem, String displayName, Long metricReference, String name, MetricType metricType, Boolean isMetricSourceEnabled, Operator operator, List<LogAnalyticsSource> sources, String entityType, Date timeUpdated, String unitType, Boolean isUserCustomized) {
        this.aggregationField = aggregationField;
        this.bucketMetadata = bucketMetadata;
        this.clockPeriod = clockPeriod;
        this.description = description;
        this.editVersion = editVersion;
        this.fieldName = fieldName;
        this.fieldValues = fieldValues;
        this.groupingField = groupingField;
        this.isEnabled = isEnabled;
        this.isSystem = isSystem;
        this.displayName = displayName;
        this.metricReference = metricReference;
        this.name = name;
        this.metricType = metricType;
        this.isMetricSourceEnabled = isMetricSourceEnabled;
        this.operator = operator;
        this.sources = sources;
        this.entityType = entityType;
        this.timeUpdated = timeUpdated;
        this.unitType = unitType;
        this.isUserCustomized = isUserCustomized;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAggregationField() {
        return this.aggregationField;
    }

    public String getBucketMetadata() {
        return this.bucketMetadata;
    }

    public String getClockPeriod() {
        return this.clockPeriod;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getEditVersion() {
        return this.editVersion;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<String> getFieldValues() {
        return this.fieldValues;
    }

    public String getGroupingField() {
        return this.groupingField;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getMetricReference() {
        return this.metricReference;
    }

    public String getName() {
        return this.name;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public Boolean getIsMetricSourceEnabled() {
        return this.isMetricSourceEnabled;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<LogAnalyticsSource> getSources() {
        return this.sources;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public Boolean getIsUserCustomized() {
        return this.isUserCustomized;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsMetric(");
        sb.append("super=").append(super.toString());
        sb.append("aggregationField=").append(String.valueOf(this.aggregationField));
        sb.append(", bucketMetadata=").append(String.valueOf(this.bucketMetadata));
        sb.append(", clockPeriod=").append(String.valueOf(this.clockPeriod));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", editVersion=").append(String.valueOf(this.editVersion));
        sb.append(", fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", fieldValues=").append(String.valueOf(this.fieldValues));
        sb.append(", groupingField=").append(String.valueOf(this.groupingField));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", metricReference=").append(String.valueOf(this.metricReference));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", metricType=").append(String.valueOf((Object)this.metricType));
        sb.append(", isMetricSourceEnabled=").append(String.valueOf(this.isMetricSourceEnabled));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(", sources=").append(String.valueOf(this.sources));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", unitType=").append(String.valueOf(this.unitType));
        sb.append(", isUserCustomized=").append(String.valueOf(this.isUserCustomized));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsMetric)) {
            return false;
        }
        LogAnalyticsMetric other = (LogAnalyticsMetric)((Object)o);
        return Objects.equals(this.aggregationField, other.aggregationField) && Objects.equals(this.bucketMetadata, other.bucketMetadata) && Objects.equals(this.clockPeriod, other.clockPeriod) && Objects.equals(this.description, other.description) && Objects.equals(this.editVersion, other.editVersion) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.fieldValues, other.fieldValues) && Objects.equals(this.groupingField, other.groupingField) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.metricReference, other.metricReference) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.metricType, (Object)other.metricType) && Objects.equals(this.isMetricSourceEnabled, other.isMetricSourceEnabled) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.sources, other.sources) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.unitType, other.unitType) && Objects.equals(this.isUserCustomized, other.isUserCustomized) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.aggregationField == null ? 43 : this.aggregationField.hashCode());
        result = result * 59 + (this.bucketMetadata == null ? 43 : this.bucketMetadata.hashCode());
        result = result * 59 + (this.clockPeriod == null ? 43 : this.clockPeriod.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.editVersion == null ? 43 : this.editVersion.hashCode());
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.fieldValues == null ? 43 : this.fieldValues.hashCode());
        result = result * 59 + (this.groupingField == null ? 43 : this.groupingField.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.metricReference == null ? 43 : this.metricReference.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.metricType == null ? 43 : this.metricType.hashCode());
        result = result * 59 + (this.isMetricSourceEnabled == null ? 43 : this.isMetricSourceEnabled.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.sources == null ? 43 : this.sources.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.unitType == null ? 43 : this.unitType.hashCode());
        result = result * 59 + (this.isUserCustomized == null ? 43 : this.isUserCustomized.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Operator implements BmcEnum
    {
        ContainsIgnoreCase("CONTAINS_IGNORE_CASE"),
        InIgnoreCase("IN_IGNORE_CASE"),
        EqualIgnoreCase("EQUAL_IGNORE_CASE"),
        NotNull("NOT_NULL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Operator> map;

        private Operator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Operator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Operator.class);
            map = new HashMap<String, Operator>();
            for (Operator v : Operator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MetricType implements BmcEnum
    {
        Count("COUNT"),
        Sum("SUM"),
        Average("AVERAGE"),
        CountDistribution("COUNT_DISTRIBUTION"),
        SumDistribution("SUM_DISTRIBUTION"),
        AverageDistribution("AVERAGE_DISTRIBUTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MetricType> map;

        private MetricType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MetricType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MetricType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MetricType.class);
            map = new HashMap<String, MetricType>();
            for (MetricType v : MetricType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="aggregationField")
        private String aggregationField;
        @JsonProperty(value="bucketMetadata")
        private String bucketMetadata;
        @JsonProperty(value="clockPeriod")
        private String clockPeriod;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="editVersion")
        private Long editVersion;
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="fieldValues")
        private List<String> fieldValues;
        @JsonProperty(value="groupingField")
        private String groupingField;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="metricReference")
        private Long metricReference;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="metricType")
        private MetricType metricType;
        @JsonProperty(value="isMetricSourceEnabled")
        private Boolean isMetricSourceEnabled;
        @JsonProperty(value="operator")
        private Operator operator;
        @JsonProperty(value="sources")
        private List<LogAnalyticsSource> sources;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="unitType")
        private String unitType;
        @JsonProperty(value="isUserCustomized")
        private Boolean isUserCustomized;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            this.__explicitlySet__.add("aggregationField");
            return this;
        }

        public Builder bucketMetadata(String bucketMetadata) {
            this.bucketMetadata = bucketMetadata;
            this.__explicitlySet__.add("bucketMetadata");
            return this;
        }

        public Builder clockPeriod(String clockPeriod) {
            this.clockPeriod = clockPeriod;
            this.__explicitlySet__.add("clockPeriod");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder editVersion(Long editVersion) {
            this.editVersion = editVersion;
            this.__explicitlySet__.add("editVersion");
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder fieldValues(List<String> fieldValues) {
            this.fieldValues = fieldValues;
            this.__explicitlySet__.add("fieldValues");
            return this;
        }

        public Builder groupingField(String groupingField) {
            this.groupingField = groupingField;
            this.__explicitlySet__.add("groupingField");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder metricReference(Long metricReference) {
            this.metricReference = metricReference;
            this.__explicitlySet__.add("metricReference");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder metricType(MetricType metricType) {
            this.metricType = metricType;
            this.__explicitlySet__.add("metricType");
            return this;
        }

        public Builder isMetricSourceEnabled(Boolean isMetricSourceEnabled) {
            this.isMetricSourceEnabled = isMetricSourceEnabled;
            this.__explicitlySet__.add("isMetricSourceEnabled");
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder sources(List<LogAnalyticsSource> sources) {
            this.sources = sources;
            this.__explicitlySet__.add("sources");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder unitType(String unitType) {
            this.unitType = unitType;
            this.__explicitlySet__.add("unitType");
            return this;
        }

        public Builder isUserCustomized(Boolean isUserCustomized) {
            this.isUserCustomized = isUserCustomized;
            this.__explicitlySet__.add("isUserCustomized");
            return this;
        }

        public LogAnalyticsMetric build() {
            LogAnalyticsMetric model = new LogAnalyticsMetric(this.aggregationField, this.bucketMetadata, this.clockPeriod, this.description, this.editVersion, this.fieldName, this.fieldValues, this.groupingField, this.isEnabled, this.isSystem, this.displayName, this.metricReference, this.name, this.metricType, this.isMetricSourceEnabled, this.operator, this.sources, this.entityType, this.timeUpdated, this.unitType, this.isUserCustomized);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsMetric model) {
            if (model.wasPropertyExplicitlySet("aggregationField")) {
                this.aggregationField(model.getAggregationField());
            }
            if (model.wasPropertyExplicitlySet("bucketMetadata")) {
                this.bucketMetadata(model.getBucketMetadata());
            }
            if (model.wasPropertyExplicitlySet("clockPeriod")) {
                this.clockPeriod(model.getClockPeriod());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("editVersion")) {
                this.editVersion(model.getEditVersion());
            }
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("fieldValues")) {
                this.fieldValues(model.getFieldValues());
            }
            if (model.wasPropertyExplicitlySet("groupingField")) {
                this.groupingField(model.getGroupingField());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("metricReference")) {
                this.metricReference(model.getMetricReference());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("metricType")) {
                this.metricType(model.getMetricType());
            }
            if (model.wasPropertyExplicitlySet("isMetricSourceEnabled")) {
                this.isMetricSourceEnabled(model.getIsMetricSourceEnabled());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("sources")) {
                this.sources(model.getSources());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("unitType")) {
                this.unitType(model.getUnitType());
            }
            if (model.wasPropertyExplicitlySet("isUserCustomized")) {
                this.isUserCustomized(model.getIsUserCustomized());
            }
            return this;
        }
    }
}

