/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.DependentParser;
import com.oracle.bmc.loganalytics.model.DependentSource;
import com.oracle.bmc.loganalytics.model.LogAnalyticsCategory;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParserField;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParserFilter;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParserFunction;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSource;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsParser
extends ExplicitlySetBmcModel {
    @JsonProperty(value="content")
    private final String content;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="editVersion")
    private final Long editVersion;
    @JsonProperty(value="encoding")
    private final String encoding;
    @JsonProperty(value="exampleContent")
    private final String exampleContent;
    @JsonProperty(value="fieldMaps")
    private final List<LogAnalyticsParserField> fieldMaps;
    @JsonProperty(value="footerContent")
    private final String footerContent;
    @JsonProperty(value="headerContent")
    private final String headerContent;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;
    @JsonProperty(value="isSingleLineContent")
    private final Boolean isSingleLineContent;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="language")
    private final String language;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="logTypeTestRequestVersion")
    private final Integer logTypeTestRequestVersion;
    @JsonProperty(value="mappedParsers")
    private final List<LogAnalyticsParser> mappedParsers;
    @JsonProperty(value="parserIgnorelineCharacters")
    private final String parserIgnorelineCharacters;
    @JsonProperty(value="isHidden")
    private final Boolean isHidden;
    @JsonProperty(value="parserSequence")
    private final Integer parserSequence;
    @JsonProperty(value="parserTimezone")
    private final String parserTimezone;
    @JsonProperty(value="parserFilter")
    private final LogAnalyticsParserFilter parserFilter;
    @JsonProperty(value="isParserWrittenOnce")
    private final Boolean isParserWrittenOnce;
    @JsonProperty(value="parserFunctions")
    private final List<LogAnalyticsParserFunction> parserFunctions;
    @JsonProperty(value="sourcesCount")
    private final Long sourcesCount;
    @JsonProperty(value="sources")
    private final List<LogAnalyticsSource> sources;
    @JsonProperty(value="shouldTokenizeOriginalText")
    private final Boolean shouldTokenizeOriginalText;
    @JsonProperty(value="fieldDelimiter")
    private final String fieldDelimiter;
    @JsonProperty(value="fieldQualifier")
    private final String fieldQualifier;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="isUserDeleted")
    private final Boolean isUserDeleted;
    @JsonProperty(value="isNamespaceAware")
    private final Boolean isNamespaceAware;
    @JsonProperty(value="categories")
    private final List<LogAnalyticsCategory> categories;
    @JsonProperty(value="isPositionAware")
    private final Boolean isPositionAware;
    @JsonProperty(value="dependentSources")
    private final List<DependentSource> dependentSources;
    @JsonProperty(value="dependentParsers")
    private final List<DependentParser> dependentParsers;

    @Deprecated
    @ConstructorProperties(value={"content", "description", "displayName", "editVersion", "encoding", "exampleContent", "fieldMaps", "footerContent", "headerContent", "name", "isDefault", "isSingleLineContent", "isSystem", "language", "timeUpdated", "logTypeTestRequestVersion", "mappedParsers", "parserIgnorelineCharacters", "isHidden", "parserSequence", "parserTimezone", "parserFilter", "isParserWrittenOnce", "parserFunctions", "sourcesCount", "sources", "shouldTokenizeOriginalText", "fieldDelimiter", "fieldQualifier", "type", "isUserDeleted", "isNamespaceAware", "categories", "isPositionAware", "dependentSources", "dependentParsers"})
    public LogAnalyticsParser(String content, String description, String displayName, Long editVersion, String encoding, String exampleContent, List<LogAnalyticsParserField> fieldMaps, String footerContent, String headerContent, String name, Boolean isDefault, Boolean isSingleLineContent, Boolean isSystem, String language, Date timeUpdated, Integer logTypeTestRequestVersion, List<LogAnalyticsParser> mappedParsers, String parserIgnorelineCharacters, Boolean isHidden, Integer parserSequence, String parserTimezone, LogAnalyticsParserFilter parserFilter, Boolean isParserWrittenOnce, List<LogAnalyticsParserFunction> parserFunctions, Long sourcesCount, List<LogAnalyticsSource> sources, Boolean shouldTokenizeOriginalText, String fieldDelimiter, String fieldQualifier, Type type, Boolean isUserDeleted, Boolean isNamespaceAware, List<LogAnalyticsCategory> categories, Boolean isPositionAware, List<DependentSource> dependentSources, List<DependentParser> dependentParsers) {
        this.content = content;
        this.description = description;
        this.displayName = displayName;
        this.editVersion = editVersion;
        this.encoding = encoding;
        this.exampleContent = exampleContent;
        this.fieldMaps = fieldMaps;
        this.footerContent = footerContent;
        this.headerContent = headerContent;
        this.name = name;
        this.isDefault = isDefault;
        this.isSingleLineContent = isSingleLineContent;
        this.isSystem = isSystem;
        this.language = language;
        this.timeUpdated = timeUpdated;
        this.logTypeTestRequestVersion = logTypeTestRequestVersion;
        this.mappedParsers = mappedParsers;
        this.parserIgnorelineCharacters = parserIgnorelineCharacters;
        this.isHidden = isHidden;
        this.parserSequence = parserSequence;
        this.parserTimezone = parserTimezone;
        this.parserFilter = parserFilter;
        this.isParserWrittenOnce = isParserWrittenOnce;
        this.parserFunctions = parserFunctions;
        this.sourcesCount = sourcesCount;
        this.sources = sources;
        this.shouldTokenizeOriginalText = shouldTokenizeOriginalText;
        this.fieldDelimiter = fieldDelimiter;
        this.fieldQualifier = fieldQualifier;
        this.type = type;
        this.isUserDeleted = isUserDeleted;
        this.isNamespaceAware = isNamespaceAware;
        this.categories = categories;
        this.isPositionAware = isPositionAware;
        this.dependentSources = dependentSources;
        this.dependentParsers = dependentParsers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getContent() {
        return this.content;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getEditVersion() {
        return this.editVersion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getExampleContent() {
        return this.exampleContent;
    }

    public List<LogAnalyticsParserField> getFieldMaps() {
        return this.fieldMaps;
    }

    public String getFooterContent() {
        return this.footerContent;
    }

    public String getHeaderContent() {
        return this.headerContent;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Boolean getIsSingleLineContent() {
        return this.isSingleLineContent;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public String getLanguage() {
        return this.language;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Integer getLogTypeTestRequestVersion() {
        return this.logTypeTestRequestVersion;
    }

    public List<LogAnalyticsParser> getMappedParsers() {
        return this.mappedParsers;
    }

    public String getParserIgnorelineCharacters() {
        return this.parserIgnorelineCharacters;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public Integer getParserSequence() {
        return this.parserSequence;
    }

    public String getParserTimezone() {
        return this.parserTimezone;
    }

    public LogAnalyticsParserFilter getParserFilter() {
        return this.parserFilter;
    }

    public Boolean getIsParserWrittenOnce() {
        return this.isParserWrittenOnce;
    }

    public List<LogAnalyticsParserFunction> getParserFunctions() {
        return this.parserFunctions;
    }

    public Long getSourcesCount() {
        return this.sourcesCount;
    }

    public List<LogAnalyticsSource> getSources() {
        return this.sources;
    }

    public Boolean getShouldTokenizeOriginalText() {
        return this.shouldTokenizeOriginalText;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getFieldQualifier() {
        return this.fieldQualifier;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getIsUserDeleted() {
        return this.isUserDeleted;
    }

    public Boolean getIsNamespaceAware() {
        return this.isNamespaceAware;
    }

    public List<LogAnalyticsCategory> getCategories() {
        return this.categories;
    }

    public Boolean getIsPositionAware() {
        return this.isPositionAware;
    }

    public List<DependentSource> getDependentSources() {
        return this.dependentSources;
    }

    public List<DependentParser> getDependentParsers() {
        return this.dependentParsers;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsParser(");
        sb.append("super=").append(super.toString());
        sb.append("content=").append(String.valueOf(this.content));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", editVersion=").append(String.valueOf(this.editVersion));
        sb.append(", encoding=").append(String.valueOf(this.encoding));
        sb.append(", exampleContent=").append(String.valueOf(this.exampleContent));
        sb.append(", fieldMaps=").append(String.valueOf(this.fieldMaps));
        sb.append(", footerContent=").append(String.valueOf(this.footerContent));
        sb.append(", headerContent=").append(String.valueOf(this.headerContent));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(", isSingleLineContent=").append(String.valueOf(this.isSingleLineContent));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", language=").append(String.valueOf(this.language));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", logTypeTestRequestVersion=").append(String.valueOf(this.logTypeTestRequestVersion));
        sb.append(", mappedParsers=").append(String.valueOf(this.mappedParsers));
        sb.append(", parserIgnorelineCharacters=").append(String.valueOf(this.parserIgnorelineCharacters));
        sb.append(", isHidden=").append(String.valueOf(this.isHidden));
        sb.append(", parserSequence=").append(String.valueOf(this.parserSequence));
        sb.append(", parserTimezone=").append(String.valueOf(this.parserTimezone));
        sb.append(", parserFilter=").append(String.valueOf((Object)this.parserFilter));
        sb.append(", isParserWrittenOnce=").append(String.valueOf(this.isParserWrittenOnce));
        sb.append(", parserFunctions=").append(String.valueOf(this.parserFunctions));
        sb.append(", sourcesCount=").append(String.valueOf(this.sourcesCount));
        sb.append(", sources=").append(String.valueOf(this.sources));
        sb.append(", shouldTokenizeOriginalText=").append(String.valueOf(this.shouldTokenizeOriginalText));
        sb.append(", fieldDelimiter=").append(String.valueOf(this.fieldDelimiter));
        sb.append(", fieldQualifier=").append(String.valueOf(this.fieldQualifier));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", isUserDeleted=").append(String.valueOf(this.isUserDeleted));
        sb.append(", isNamespaceAware=").append(String.valueOf(this.isNamespaceAware));
        sb.append(", categories=").append(String.valueOf(this.categories));
        sb.append(", isPositionAware=").append(String.valueOf(this.isPositionAware));
        sb.append(", dependentSources=").append(String.valueOf(this.dependentSources));
        sb.append(", dependentParsers=").append(String.valueOf(this.dependentParsers));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsParser)) {
            return false;
        }
        LogAnalyticsParser other = (LogAnalyticsParser)((Object)o);
        return Objects.equals(this.content, other.content) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.editVersion, other.editVersion) && Objects.equals(this.encoding, other.encoding) && Objects.equals(this.exampleContent, other.exampleContent) && Objects.equals(this.fieldMaps, other.fieldMaps) && Objects.equals(this.footerContent, other.footerContent) && Objects.equals(this.headerContent, other.headerContent) && Objects.equals(this.name, other.name) && Objects.equals(this.isDefault, other.isDefault) && Objects.equals(this.isSingleLineContent, other.isSingleLineContent) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.language, other.language) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.logTypeTestRequestVersion, other.logTypeTestRequestVersion) && Objects.equals(this.mappedParsers, other.mappedParsers) && Objects.equals(this.parserIgnorelineCharacters, other.parserIgnorelineCharacters) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.parserSequence, other.parserSequence) && Objects.equals(this.parserTimezone, other.parserTimezone) && Objects.equals((Object)this.parserFilter, (Object)other.parserFilter) && Objects.equals(this.isParserWrittenOnce, other.isParserWrittenOnce) && Objects.equals(this.parserFunctions, other.parserFunctions) && Objects.equals(this.sourcesCount, other.sourcesCount) && Objects.equals(this.sources, other.sources) && Objects.equals(this.shouldTokenizeOriginalText, other.shouldTokenizeOriginalText) && Objects.equals(this.fieldDelimiter, other.fieldDelimiter) && Objects.equals(this.fieldQualifier, other.fieldQualifier) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.isUserDeleted, other.isUserDeleted) && Objects.equals(this.isNamespaceAware, other.isNamespaceAware) && Objects.equals(this.categories, other.categories) && Objects.equals(this.isPositionAware, other.isPositionAware) && Objects.equals(this.dependentSources, other.dependentSources) && Objects.equals(this.dependentParsers, other.dependentParsers) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.editVersion == null ? 43 : this.editVersion.hashCode());
        result = result * 59 + (this.encoding == null ? 43 : this.encoding.hashCode());
        result = result * 59 + (this.exampleContent == null ? 43 : this.exampleContent.hashCode());
        result = result * 59 + (this.fieldMaps == null ? 43 : this.fieldMaps.hashCode());
        result = result * 59 + (this.footerContent == null ? 43 : this.footerContent.hashCode());
        result = result * 59 + (this.headerContent == null ? 43 : this.headerContent.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + (this.isSingleLineContent == null ? 43 : this.isSingleLineContent.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.language == null ? 43 : this.language.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.logTypeTestRequestVersion == null ? 43 : this.logTypeTestRequestVersion.hashCode());
        result = result * 59 + (this.mappedParsers == null ? 43 : this.mappedParsers.hashCode());
        result = result * 59 + (this.parserIgnorelineCharacters == null ? 43 : this.parserIgnorelineCharacters.hashCode());
        result = result * 59 + (this.isHidden == null ? 43 : this.isHidden.hashCode());
        result = result * 59 + (this.parserSequence == null ? 43 : this.parserSequence.hashCode());
        result = result * 59 + (this.parserTimezone == null ? 43 : this.parserTimezone.hashCode());
        result = result * 59 + (this.parserFilter == null ? 43 : this.parserFilter.hashCode());
        result = result * 59 + (this.isParserWrittenOnce == null ? 43 : this.isParserWrittenOnce.hashCode());
        result = result * 59 + (this.parserFunctions == null ? 43 : this.parserFunctions.hashCode());
        result = result * 59 + (this.sourcesCount == null ? 43 : this.sourcesCount.hashCode());
        result = result * 59 + (this.sources == null ? 43 : this.sources.hashCode());
        result = result * 59 + (this.shouldTokenizeOriginalText == null ? 43 : this.shouldTokenizeOriginalText.hashCode());
        result = result * 59 + (this.fieldDelimiter == null ? 43 : this.fieldDelimiter.hashCode());
        result = result * 59 + (this.fieldQualifier == null ? 43 : this.fieldQualifier.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.isUserDeleted == null ? 43 : this.isUserDeleted.hashCode());
        result = result * 59 + (this.isNamespaceAware == null ? 43 : this.isNamespaceAware.hashCode());
        result = result * 59 + (this.categories == null ? 43 : this.categories.hashCode());
        result = result * 59 + (this.isPositionAware == null ? 43 : this.isPositionAware.hashCode());
        result = result * 59 + (this.dependentSources == null ? 43 : this.dependentSources.hashCode());
        result = result * 59 + (this.dependentParsers == null ? 43 : this.dependentParsers.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Xml("XML"),
        Json("JSON"),
        Regex("REGEX"),
        Odl("ODL"),
        Delimited("DELIMITED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="content")
        private String content;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="editVersion")
        private Long editVersion;
        @JsonProperty(value="encoding")
        private String encoding;
        @JsonProperty(value="exampleContent")
        private String exampleContent;
        @JsonProperty(value="fieldMaps")
        private List<LogAnalyticsParserField> fieldMaps;
        @JsonProperty(value="footerContent")
        private String footerContent;
        @JsonProperty(value="headerContent")
        private String headerContent;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonProperty(value="isSingleLineContent")
        private Boolean isSingleLineContent;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="language")
        private String language;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="logTypeTestRequestVersion")
        private Integer logTypeTestRequestVersion;
        @JsonProperty(value="mappedParsers")
        private List<LogAnalyticsParser> mappedParsers;
        @JsonProperty(value="parserIgnorelineCharacters")
        private String parserIgnorelineCharacters;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="parserSequence")
        private Integer parserSequence;
        @JsonProperty(value="parserTimezone")
        private String parserTimezone;
        @JsonProperty(value="parserFilter")
        private LogAnalyticsParserFilter parserFilter;
        @JsonProperty(value="isParserWrittenOnce")
        private Boolean isParserWrittenOnce;
        @JsonProperty(value="parserFunctions")
        private List<LogAnalyticsParserFunction> parserFunctions;
        @JsonProperty(value="sourcesCount")
        private Long sourcesCount;
        @JsonProperty(value="sources")
        private List<LogAnalyticsSource> sources;
        @JsonProperty(value="shouldTokenizeOriginalText")
        private Boolean shouldTokenizeOriginalText;
        @JsonProperty(value="fieldDelimiter")
        private String fieldDelimiter;
        @JsonProperty(value="fieldQualifier")
        private String fieldQualifier;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="isUserDeleted")
        private Boolean isUserDeleted;
        @JsonProperty(value="isNamespaceAware")
        private Boolean isNamespaceAware;
        @JsonProperty(value="categories")
        private List<LogAnalyticsCategory> categories;
        @JsonProperty(value="isPositionAware")
        private Boolean isPositionAware;
        @JsonProperty(value="dependentSources")
        private List<DependentSource> dependentSources;
        @JsonProperty(value="dependentParsers")
        private List<DependentParser> dependentParsers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder content(String content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder editVersion(Long editVersion) {
            this.editVersion = editVersion;
            this.__explicitlySet__.add("editVersion");
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            this.__explicitlySet__.add("encoding");
            return this;
        }

        public Builder exampleContent(String exampleContent) {
            this.exampleContent = exampleContent;
            this.__explicitlySet__.add("exampleContent");
            return this;
        }

        public Builder fieldMaps(List<LogAnalyticsParserField> fieldMaps) {
            this.fieldMaps = fieldMaps;
            this.__explicitlySet__.add("fieldMaps");
            return this;
        }

        public Builder footerContent(String footerContent) {
            this.footerContent = footerContent;
            this.__explicitlySet__.add("footerContent");
            return this;
        }

        public Builder headerContent(String headerContent) {
            this.headerContent = headerContent;
            this.__explicitlySet__.add("headerContent");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public Builder isSingleLineContent(Boolean isSingleLineContent) {
            this.isSingleLineContent = isSingleLineContent;
            this.__explicitlySet__.add("isSingleLineContent");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.__explicitlySet__.add("language");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder logTypeTestRequestVersion(Integer logTypeTestRequestVersion) {
            this.logTypeTestRequestVersion = logTypeTestRequestVersion;
            this.__explicitlySet__.add("logTypeTestRequestVersion");
            return this;
        }

        public Builder mappedParsers(List<LogAnalyticsParser> mappedParsers) {
            this.mappedParsers = mappedParsers;
            this.__explicitlySet__.add("mappedParsers");
            return this;
        }

        public Builder parserIgnorelineCharacters(String parserIgnorelineCharacters) {
            this.parserIgnorelineCharacters = parserIgnorelineCharacters;
            this.__explicitlySet__.add("parserIgnorelineCharacters");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder parserSequence(Integer parserSequence) {
            this.parserSequence = parserSequence;
            this.__explicitlySet__.add("parserSequence");
            return this;
        }

        public Builder parserTimezone(String parserTimezone) {
            this.parserTimezone = parserTimezone;
            this.__explicitlySet__.add("parserTimezone");
            return this;
        }

        public Builder parserFilter(LogAnalyticsParserFilter parserFilter) {
            this.parserFilter = parserFilter;
            this.__explicitlySet__.add("parserFilter");
            return this;
        }

        public Builder isParserWrittenOnce(Boolean isParserWrittenOnce) {
            this.isParserWrittenOnce = isParserWrittenOnce;
            this.__explicitlySet__.add("isParserWrittenOnce");
            return this;
        }

        public Builder parserFunctions(List<LogAnalyticsParserFunction> parserFunctions) {
            this.parserFunctions = parserFunctions;
            this.__explicitlySet__.add("parserFunctions");
            return this;
        }

        public Builder sourcesCount(Long sourcesCount) {
            this.sourcesCount = sourcesCount;
            this.__explicitlySet__.add("sourcesCount");
            return this;
        }

        public Builder sources(List<LogAnalyticsSource> sources) {
            this.sources = sources;
            this.__explicitlySet__.add("sources");
            return this;
        }

        public Builder shouldTokenizeOriginalText(Boolean shouldTokenizeOriginalText) {
            this.shouldTokenizeOriginalText = shouldTokenizeOriginalText;
            this.__explicitlySet__.add("shouldTokenizeOriginalText");
            return this;
        }

        public Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            this.__explicitlySet__.add("fieldDelimiter");
            return this;
        }

        public Builder fieldQualifier(String fieldQualifier) {
            this.fieldQualifier = fieldQualifier;
            this.__explicitlySet__.add("fieldQualifier");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder isUserDeleted(Boolean isUserDeleted) {
            this.isUserDeleted = isUserDeleted;
            this.__explicitlySet__.add("isUserDeleted");
            return this;
        }

        public Builder isNamespaceAware(Boolean isNamespaceAware) {
            this.isNamespaceAware = isNamespaceAware;
            this.__explicitlySet__.add("isNamespaceAware");
            return this;
        }

        public Builder categories(List<LogAnalyticsCategory> categories) {
            this.categories = categories;
            this.__explicitlySet__.add("categories");
            return this;
        }

        public Builder isPositionAware(Boolean isPositionAware) {
            this.isPositionAware = isPositionAware;
            this.__explicitlySet__.add("isPositionAware");
            return this;
        }

        public Builder dependentSources(List<DependentSource> dependentSources) {
            this.dependentSources = dependentSources;
            this.__explicitlySet__.add("dependentSources");
            return this;
        }

        public Builder dependentParsers(List<DependentParser> dependentParsers) {
            this.dependentParsers = dependentParsers;
            this.__explicitlySet__.add("dependentParsers");
            return this;
        }

        public LogAnalyticsParser build() {
            LogAnalyticsParser model = new LogAnalyticsParser(this.content, this.description, this.displayName, this.editVersion, this.encoding, this.exampleContent, this.fieldMaps, this.footerContent, this.headerContent, this.name, this.isDefault, this.isSingleLineContent, this.isSystem, this.language, this.timeUpdated, this.logTypeTestRequestVersion, this.mappedParsers, this.parserIgnorelineCharacters, this.isHidden, this.parserSequence, this.parserTimezone, this.parserFilter, this.isParserWrittenOnce, this.parserFunctions, this.sourcesCount, this.sources, this.shouldTokenizeOriginalText, this.fieldDelimiter, this.fieldQualifier, this.type, this.isUserDeleted, this.isNamespaceAware, this.categories, this.isPositionAware, this.dependentSources, this.dependentParsers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsParser model) {
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("editVersion")) {
                this.editVersion(model.getEditVersion());
            }
            if (model.wasPropertyExplicitlySet("encoding")) {
                this.encoding(model.getEncoding());
            }
            if (model.wasPropertyExplicitlySet("exampleContent")) {
                this.exampleContent(model.getExampleContent());
            }
            if (model.wasPropertyExplicitlySet("fieldMaps")) {
                this.fieldMaps(model.getFieldMaps());
            }
            if (model.wasPropertyExplicitlySet("footerContent")) {
                this.footerContent(model.getFooterContent());
            }
            if (model.wasPropertyExplicitlySet("headerContent")) {
                this.headerContent(model.getHeaderContent());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            if (model.wasPropertyExplicitlySet("isSingleLineContent")) {
                this.isSingleLineContent(model.getIsSingleLineContent());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("language")) {
                this.language(model.getLanguage());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("logTypeTestRequestVersion")) {
                this.logTypeTestRequestVersion(model.getLogTypeTestRequestVersion());
            }
            if (model.wasPropertyExplicitlySet("mappedParsers")) {
                this.mappedParsers(model.getMappedParsers());
            }
            if (model.wasPropertyExplicitlySet("parserIgnorelineCharacters")) {
                this.parserIgnorelineCharacters(model.getParserIgnorelineCharacters());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("parserSequence")) {
                this.parserSequence(model.getParserSequence());
            }
            if (model.wasPropertyExplicitlySet("parserTimezone")) {
                this.parserTimezone(model.getParserTimezone());
            }
            if (model.wasPropertyExplicitlySet("parserFilter")) {
                this.parserFilter(model.getParserFilter());
            }
            if (model.wasPropertyExplicitlySet("isParserWrittenOnce")) {
                this.isParserWrittenOnce(model.getIsParserWrittenOnce());
            }
            if (model.wasPropertyExplicitlySet("parserFunctions")) {
                this.parserFunctions(model.getParserFunctions());
            }
            if (model.wasPropertyExplicitlySet("sourcesCount")) {
                this.sourcesCount(model.getSourcesCount());
            }
            if (model.wasPropertyExplicitlySet("sources")) {
                this.sources(model.getSources());
            }
            if (model.wasPropertyExplicitlySet("shouldTokenizeOriginalText")) {
                this.shouldTokenizeOriginalText(model.getShouldTokenizeOriginalText());
            }
            if (model.wasPropertyExplicitlySet("fieldDelimiter")) {
                this.fieldDelimiter(model.getFieldDelimiter());
            }
            if (model.wasPropertyExplicitlySet("fieldQualifier")) {
                this.fieldQualifier(model.getFieldQualifier());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("isUserDeleted")) {
                this.isUserDeleted(model.getIsUserDeleted());
            }
            if (model.wasPropertyExplicitlySet("isNamespaceAware")) {
                this.isNamespaceAware(model.getIsNamespaceAware());
            }
            if (model.wasPropertyExplicitlySet("categories")) {
                this.categories(model.getCategories());
            }
            if (model.wasPropertyExplicitlySet("isPositionAware")) {
                this.isPositionAware(model.getIsPositionAware());
            }
            if (model.wasPropertyExplicitlySet("dependentSources")) {
                this.dependentSources(model.getDependentSources());
            }
            if (model.wasPropertyExplicitlySet("dependentParsers")) {
                this.dependentParsers(model.getDependentParsers());
            }
            return this;
        }
    }
}

