/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.EndpointCredentials;
import com.oracle.bmc.loganalytics.model.EndpointProxy;
import com.oracle.bmc.loganalytics.model.EndpointRequest;
import com.oracle.bmc.loganalytics.model.EndpointResponse;
import com.oracle.bmc.loganalytics.model.LogAnalyticsProperty;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogEndpoint
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="model")
    private final String model;
    @JsonProperty(value="endpointId")
    private final Long endpointId;
    @JsonProperty(value="request")
    private final EndpointRequest request;
    @JsonProperty(value="response")
    private final EndpointResponse response;
    @JsonProperty(value="credentials")
    private final EndpointCredentials credentials;
    @JsonProperty(value="proxy")
    private final EndpointProxy proxy;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="endpointProperties")
    private final List<LogAnalyticsProperty> endpointProperties;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "model", "endpointId", "request", "response", "credentials", "proxy", "isEnabled", "isSystem", "endpointProperties"})
    public LogEndpoint(String name, String description, String model, Long endpointId, EndpointRequest request, EndpointResponse response, EndpointCredentials credentials, EndpointProxy proxy, Boolean isEnabled, Boolean isSystem, List<LogAnalyticsProperty> endpointProperties) {
        this.name = name;
        this.description = description;
        this.model = model;
        this.endpointId = endpointId;
        this.request = request;
        this.response = response;
        this.credentials = credentials;
        this.proxy = proxy;
        this.isEnabled = isEnabled;
        this.isSystem = isSystem;
        this.endpointProperties = endpointProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModel() {
        return this.model;
    }

    public Long getEndpointId() {
        return this.endpointId;
    }

    public EndpointRequest getRequest() {
        return this.request;
    }

    public EndpointResponse getResponse() {
        return this.response;
    }

    public EndpointCredentials getCredentials() {
        return this.credentials;
    }

    public EndpointProxy getProxy() {
        return this.proxy;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public List<LogAnalyticsProperty> getEndpointProperties() {
        return this.endpointProperties;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogEndpoint(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", model=").append(String.valueOf(this.model));
        sb.append(", endpointId=").append(String.valueOf(this.endpointId));
        sb.append(", request=").append(String.valueOf((Object)this.request));
        sb.append(", response=").append(String.valueOf((Object)this.response));
        sb.append(", credentials=").append(String.valueOf((Object)this.credentials));
        sb.append(", proxy=").append(String.valueOf((Object)this.proxy));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", endpointProperties=").append(String.valueOf(this.endpointProperties));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogEndpoint)) {
            return false;
        }
        LogEndpoint other = (LogEndpoint)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.model, other.model) && Objects.equals(this.endpointId, other.endpointId) && Objects.equals((Object)this.request, (Object)other.request) && Objects.equals((Object)this.response, (Object)other.response) && Objects.equals((Object)this.credentials, (Object)other.credentials) && Objects.equals((Object)this.proxy, (Object)other.proxy) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.endpointProperties, other.endpointProperties) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.model == null ? 43 : this.model.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        result = result * 59 + (this.request == null ? 43 : this.request.hashCode());
        result = result * 59 + (this.response == null ? 43 : this.response.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.proxy == null ? 43 : this.proxy.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.endpointProperties == null ? 43 : this.endpointProperties.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="model")
        private String model;
        @JsonProperty(value="endpointId")
        private Long endpointId;
        @JsonProperty(value="request")
        private EndpointRequest request;
        @JsonProperty(value="response")
        private EndpointResponse response;
        @JsonProperty(value="credentials")
        private EndpointCredentials credentials;
        @JsonProperty(value="proxy")
        private EndpointProxy proxy;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="endpointProperties")
        private List<LogAnalyticsProperty> endpointProperties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.__explicitlySet__.add("model");
            return this;
        }

        public Builder endpointId(Long endpointId) {
            this.endpointId = endpointId;
            this.__explicitlySet__.add("endpointId");
            return this;
        }

        public Builder request(EndpointRequest request) {
            this.request = request;
            this.__explicitlySet__.add("request");
            return this;
        }

        public Builder response(EndpointResponse response) {
            this.response = response;
            this.__explicitlySet__.add("response");
            return this;
        }

        public Builder credentials(EndpointCredentials credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder proxy(EndpointProxy proxy) {
            this.proxy = proxy;
            this.__explicitlySet__.add("proxy");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder endpointProperties(List<LogAnalyticsProperty> endpointProperties) {
            this.endpointProperties = endpointProperties;
            this.__explicitlySet__.add("endpointProperties");
            return this;
        }

        public LogEndpoint build() {
            LogEndpoint model = new LogEndpoint(this.name, this.description, this.model, this.endpointId, this.request, this.response, this.credentials, this.proxy, this.isEnabled, this.isSystem, this.endpointProperties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogEndpoint model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("model")) {
                this.model(model.getModel());
            }
            if (model.wasPropertyExplicitlySet("endpointId")) {
                this.endpointId(model.getEndpointId());
            }
            if (model.wasPropertyExplicitlySet("request")) {
                this.request(model.getRequest());
            }
            if (model.wasPropertyExplicitlySet("response")) {
                this.response(model.getResponse());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("proxy")) {
                this.proxy(model.getProxy());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("endpointProperties")) {
                this.endpointProperties(model.getEndpointProperties());
            }
            return this;
        }
    }
}

