/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RuleSummaryReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalCount")
    private final Integer totalCount;
    @JsonProperty(value="ingestTimeRulesCount")
    private final Integer ingestTimeRulesCount;
    @JsonProperty(value="savedSearchRulesCount")
    private final Integer savedSearchRulesCount;

    @Deprecated
    @ConstructorProperties(value={"totalCount", "ingestTimeRulesCount", "savedSearchRulesCount"})
    public RuleSummaryReport(Integer totalCount, Integer ingestTimeRulesCount, Integer savedSearchRulesCount) {
        this.totalCount = totalCount;
        this.ingestTimeRulesCount = ingestTimeRulesCount;
        this.savedSearchRulesCount = savedSearchRulesCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public Integer getIngestTimeRulesCount() {
        return this.ingestTimeRulesCount;
    }

    public Integer getSavedSearchRulesCount() {
        return this.savedSearchRulesCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RuleSummaryReport(");
        sb.append("super=").append(super.toString());
        sb.append("totalCount=").append(String.valueOf(this.totalCount));
        sb.append(", ingestTimeRulesCount=").append(String.valueOf(this.ingestTimeRulesCount));
        sb.append(", savedSearchRulesCount=").append(String.valueOf(this.savedSearchRulesCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleSummaryReport)) {
            return false;
        }
        RuleSummaryReport other = (RuleSummaryReport)((Object)o);
        return Objects.equals(this.totalCount, other.totalCount) && Objects.equals(this.ingestTimeRulesCount, other.ingestTimeRulesCount) && Objects.equals(this.savedSearchRulesCount, other.savedSearchRulesCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalCount == null ? 43 : this.totalCount.hashCode());
        result = result * 59 + (this.ingestTimeRulesCount == null ? 43 : this.ingestTimeRulesCount.hashCode());
        result = result * 59 + (this.savedSearchRulesCount == null ? 43 : this.savedSearchRulesCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="ingestTimeRulesCount")
        private Integer ingestTimeRulesCount;
        @JsonProperty(value="savedSearchRulesCount")
        private Integer savedSearchRulesCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            this.__explicitlySet__.add("totalCount");
            return this;
        }

        public Builder ingestTimeRulesCount(Integer ingestTimeRulesCount) {
            this.ingestTimeRulesCount = ingestTimeRulesCount;
            this.__explicitlySet__.add("ingestTimeRulesCount");
            return this;
        }

        public Builder savedSearchRulesCount(Integer savedSearchRulesCount) {
            this.savedSearchRulesCount = savedSearchRulesCount;
            this.__explicitlySet__.add("savedSearchRulesCount");
            return this;
        }

        public RuleSummaryReport build() {
            RuleSummaryReport model = new RuleSummaryReport(this.totalCount, this.ingestTimeRulesCount, this.savedSearchRulesCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RuleSummaryReport model) {
            if (model.wasPropertyExplicitlySet("totalCount")) {
                this.totalCount(model.getTotalCount());
            }
            if (model.wasPropertyExplicitlySet("ingestTimeRulesCount")) {
                this.ingestTimeRulesCount(model.getIngestTimeRulesCount());
            }
            if (model.wasPropertyExplicitlySet("savedSearchRulesCount")) {
                this.savedSearchRulesCount(model.getSavedSearchRulesCount());
            }
            return this;
        }
    }
}

