/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ValueType implements BmcEnum
{
    Boolean("BOOLEAN"),
    String("STRING"),
    Double("DOUBLE"),
    Float("FLOAT"),
    Long("LONG"),
    Integer("INTEGER"),
    Timestamp("TIMESTAMP"),
    Facet("FACET"),
    Table("TABLE"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, ValueType> map;

    private ValueType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static ValueType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'ValueType', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(ValueType.class);
        map = new HashMap<String, ValueType>();
        for (ValueType v : ValueType.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

