/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListFieldsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private Boolean isMatchAll;
    private String sourceIds;
    private String sourceNames;
    private ParserType parserType;
    private String parserIds;
    private String parserNames;
    private Boolean isIncludeParser;
    private String filter;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public Boolean getIsMatchAll() {
        return this.isMatchAll;
    }

    public String getSourceIds() {
        return this.sourceIds;
    }

    public String getSourceNames() {
        return this.sourceNames;
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    public String getParserIds() {
        return this.parserIds;
    }

    public String getParserNames() {
        return this.parserNames;
    }

    public Boolean getIsIncludeParser() {
        return this.isIncludeParser;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).isMatchAll(this.isMatchAll).sourceIds(this.sourceIds).sourceNames(this.sourceNames).parserType(this.parserType).parserIds(this.parserIds).parserNames(this.parserNames).isIncludeParser(this.isIncludeParser).filter(this.filter).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",isMatchAll=").append(String.valueOf(this.isMatchAll));
        sb.append(",sourceIds=").append(String.valueOf(this.sourceIds));
        sb.append(",sourceNames=").append(String.valueOf(this.sourceNames));
        sb.append(",parserType=").append(String.valueOf((Object)this.parserType));
        sb.append(",parserIds=").append(String.valueOf(this.parserIds));
        sb.append(",parserNames=").append(String.valueOf(this.parserNames));
        sb.append(",isIncludeParser=").append(String.valueOf(this.isIncludeParser));
        sb.append(",filter=").append(String.valueOf(this.filter));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListFieldsRequest)) {
            return false;
        }
        ListFieldsRequest other = (ListFieldsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.isMatchAll, other.isMatchAll) && Objects.equals(this.sourceIds, other.sourceIds) && Objects.equals(this.sourceNames, other.sourceNames) && Objects.equals((Object)this.parserType, (Object)other.parserType) && Objects.equals(this.parserIds, other.parserIds) && Objects.equals(this.parserNames, other.parserNames) && Objects.equals(this.isIncludeParser, other.isIncludeParser) && Objects.equals(this.filter, other.filter) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.isMatchAll == null ? 43 : this.isMatchAll.hashCode());
        result = result * 59 + (this.sourceIds == null ? 43 : this.sourceIds.hashCode());
        result = result * 59 + (this.sourceNames == null ? 43 : this.sourceNames.hashCode());
        result = result * 59 + (this.parserType == null ? 43 : this.parserType.hashCode());
        result = result * 59 + (this.parserIds == null ? 43 : this.parserIds.hashCode());
        result = result * 59 + (this.parserNames == null ? 43 : this.parserNames.hashCode());
        result = result * 59 + (this.isIncludeParser == null ? 43 : this.isIncludeParser.hashCode());
        result = result * 59 + (this.filter == null ? 43 : this.filter.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListFieldsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private Boolean isMatchAll = null;
        private String sourceIds = null;
        private String sourceNames = null;
        private ParserType parserType = null;
        private String parserIds = null;
        private String parserNames = null;
        private Boolean isIncludeParser = null;
        private String filter = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder isMatchAll(Boolean isMatchAll) {
            this.isMatchAll = isMatchAll;
            return this;
        }

        public Builder sourceIds(String sourceIds) {
            this.sourceIds = sourceIds;
            return this;
        }

        public Builder sourceNames(String sourceNames) {
            this.sourceNames = sourceNames;
            return this;
        }

        public Builder parserType(ParserType parserType) {
            this.parserType = parserType;
            return this;
        }

        public Builder parserIds(String parserIds) {
            this.parserIds = parserIds;
            return this;
        }

        public Builder parserNames(String parserNames) {
            this.parserNames = parserNames;
            return this;
        }

        public Builder isIncludeParser(Boolean isIncludeParser) {
            this.isIncludeParser = isIncludeParser;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFieldsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.isMatchAll(o.getIsMatchAll());
            this.sourceIds(o.getSourceIds());
            this.sourceNames(o.getSourceNames());
            this.parserType(o.getParserType());
            this.parserIds(o.getParserIds());
            this.parserNames(o.getParserNames());
            this.isIncludeParser(o.getIsIncludeParser());
            this.filter(o.getFilter());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFieldsRequest build() {
            ListFieldsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListFieldsRequest buildWithoutInvocationCallback() {
            ListFieldsRequest request = new ListFieldsRequest();
            request.namespaceName = this.namespaceName;
            request.isMatchAll = this.isMatchAll;
            request.sourceIds = this.sourceIds;
            request.sourceNames = this.sourceNames;
            request.parserType = this.parserType;
            request.parserIds = this.parserIds;
            request.parserNames = this.parserNames;
            request.isIncludeParser = this.isIncludeParser;
            request.filter = this.filter;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("name"),
        DataType("dataType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ParserType implements BmcEnum
    {
        All("ALL"),
        Regex("REGEX"),
        Xml("XML"),
        Json("JSON"),
        Odl("ODL"),
        Delimited("DELIMITED");

        private final String value;
        private static Map<String, ParserType> map;

        private ParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ParserType: " + key);
        }

        static {
            map = new HashMap<String, ParserType>();
            for (ParserType v : ParserType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

