/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.CreationSourceType;
import com.oracle.bmc.loganalytics.model.EntityLifecycleStates;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListLogAnalyticsEntitiesRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String compartmentId;
    private String name;
    private String nameContains;
    private List<String> entityTypeName;
    private String cloudResourceId;
    private EntityLifecycleStates lifecycleState;
    private String lifecycleDetailsContains;
    private IsManagementAgentIdNull isManagementAgentIdNull;
    private String hostname;
    private String hostnameContains;
    private String sourceId;
    private List<CreationSourceType> creationSourceType;
    private String creationSourceDetails;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private List<String> metadataEquals;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameContains() {
        return this.nameContains;
    }

    public List<String> getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getCloudResourceId() {
        return this.cloudResourceId;
    }

    public EntityLifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetailsContains() {
        return this.lifecycleDetailsContains;
    }

    public IsManagementAgentIdNull getIsManagementAgentIdNull() {
        return this.isManagementAgentIdNull;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHostnameContains() {
        return this.hostnameContains;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public List<CreationSourceType> getCreationSourceType() {
        return this.creationSourceType;
    }

    public String getCreationSourceDetails() {
        return this.creationSourceDetails;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getMetadataEquals() {
        return this.metadataEquals;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).compartmentId(this.compartmentId).name(this.name).nameContains(this.nameContains).entityTypeName(this.entityTypeName).cloudResourceId(this.cloudResourceId).lifecycleState(this.lifecycleState).lifecycleDetailsContains(this.lifecycleDetailsContains).isManagementAgentIdNull(this.isManagementAgentIdNull).hostname(this.hostname).hostnameContains(this.hostnameContains).sourceId(this.sourceId).creationSourceType(this.creationSourceType).creationSourceDetails(this.creationSourceDetails).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).metadataEquals(this.metadataEquals);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",nameContains=").append(String.valueOf(this.nameContains));
        sb.append(",entityTypeName=").append(String.valueOf(this.entityTypeName));
        sb.append(",cloudResourceId=").append(String.valueOf(this.cloudResourceId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",lifecycleDetailsContains=").append(String.valueOf(this.lifecycleDetailsContains));
        sb.append(",isManagementAgentIdNull=").append(String.valueOf((Object)this.isManagementAgentIdNull));
        sb.append(",hostname=").append(String.valueOf(this.hostname));
        sb.append(",hostnameContains=").append(String.valueOf(this.hostnameContains));
        sb.append(",sourceId=").append(String.valueOf(this.sourceId));
        sb.append(",creationSourceType=").append(String.valueOf(this.creationSourceType));
        sb.append(",creationSourceDetails=").append(String.valueOf(this.creationSourceDetails));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",metadataEquals=").append(String.valueOf(this.metadataEquals));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListLogAnalyticsEntitiesRequest)) {
            return false;
        }
        ListLogAnalyticsEntitiesRequest other = (ListLogAnalyticsEntitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals(this.nameContains, other.nameContains) && Objects.equals(this.entityTypeName, other.entityTypeName) && Objects.equals(this.cloudResourceId, other.cloudResourceId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetailsContains, other.lifecycleDetailsContains) && Objects.equals((Object)this.isManagementAgentIdNull, (Object)other.isManagementAgentIdNull) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.hostnameContains, other.hostnameContains) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.creationSourceType, other.creationSourceType) && Objects.equals(this.creationSourceDetails, other.creationSourceDetails) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.metadataEquals, other.metadataEquals);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.nameContains == null ? 43 : this.nameContains.hashCode());
        result = result * 59 + (this.entityTypeName == null ? 43 : this.entityTypeName.hashCode());
        result = result * 59 + (this.cloudResourceId == null ? 43 : this.cloudResourceId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetailsContains == null ? 43 : this.lifecycleDetailsContains.hashCode());
        result = result * 59 + (this.isManagementAgentIdNull == null ? 43 : this.isManagementAgentIdNull.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.hostnameContains == null ? 43 : this.hostnameContains.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.creationSourceType == null ? 43 : this.creationSourceType.hashCode());
        result = result * 59 + (this.creationSourceDetails == null ? 43 : this.creationSourceDetails.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.metadataEquals == null ? 43 : this.metadataEquals.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLogAnalyticsEntitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String compartmentId = null;
        private String name = null;
        private String nameContains = null;
        private List<String> entityTypeName = null;
        private String cloudResourceId = null;
        private EntityLifecycleStates lifecycleState = null;
        private String lifecycleDetailsContains = null;
        private IsManagementAgentIdNull isManagementAgentIdNull = null;
        private String hostname = null;
        private String hostnameContains = null;
        private String sourceId = null;
        private List<CreationSourceType> creationSourceType = null;
        private String creationSourceDetails = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private List<String> metadataEquals = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public Builder entityTypeName(List<String> entityTypeName) {
            this.entityTypeName = entityTypeName;
            return this;
        }

        public Builder entityTypeName(String singularValue) {
            return this.entityTypeName(Arrays.asList(singularValue));
        }

        public Builder cloudResourceId(String cloudResourceId) {
            this.cloudResourceId = cloudResourceId;
            return this;
        }

        public Builder lifecycleState(EntityLifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleDetailsContains(String lifecycleDetailsContains) {
            this.lifecycleDetailsContains = lifecycleDetailsContains;
            return this;
        }

        public Builder isManagementAgentIdNull(IsManagementAgentIdNull isManagementAgentIdNull) {
            this.isManagementAgentIdNull = isManagementAgentIdNull;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder hostnameContains(String hostnameContains) {
            this.hostnameContains = hostnameContains;
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public Builder creationSourceType(List<CreationSourceType> creationSourceType) {
            this.creationSourceType = creationSourceType;
            return this;
        }

        public Builder creationSourceType(CreationSourceType singularValue) {
            return this.creationSourceType(Arrays.asList(singularValue));
        }

        public Builder creationSourceDetails(String creationSourceDetails) {
            this.creationSourceDetails = creationSourceDetails;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder metadataEquals(List<String> metadataEquals) {
            this.metadataEquals = metadataEquals;
            return this;
        }

        public Builder metadataEquals(String singularValue) {
            return this.metadataEquals(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLogAnalyticsEntitiesRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.compartmentId(o.getCompartmentId());
            this.name(o.getName());
            this.nameContains(o.getNameContains());
            this.entityTypeName(o.getEntityTypeName());
            this.cloudResourceId(o.getCloudResourceId());
            this.lifecycleState(o.getLifecycleState());
            this.lifecycleDetailsContains(o.getLifecycleDetailsContains());
            this.isManagementAgentIdNull(o.getIsManagementAgentIdNull());
            this.hostname(o.getHostname());
            this.hostnameContains(o.getHostnameContains());
            this.sourceId(o.getSourceId());
            this.creationSourceType(o.getCreationSourceType());
            this.creationSourceDetails(o.getCreationSourceDetails());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.metadataEquals(o.getMetadataEquals());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLogAnalyticsEntitiesRequest build() {
            ListLogAnalyticsEntitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListLogAnalyticsEntitiesRequest buildWithoutInvocationCallback() {
            ListLogAnalyticsEntitiesRequest request = new ListLogAnalyticsEntitiesRequest();
            request.namespaceName = this.namespaceName;
            request.compartmentId = this.compartmentId;
            request.name = this.name;
            request.nameContains = this.nameContains;
            request.entityTypeName = this.entityTypeName;
            request.cloudResourceId = this.cloudResourceId;
            request.lifecycleState = this.lifecycleState;
            request.lifecycleDetailsContains = this.lifecycleDetailsContains;
            request.isManagementAgentIdNull = this.isManagementAgentIdNull;
            request.hostname = this.hostname;
            request.hostnameContains = this.hostnameContains;
            request.sourceId = this.sourceId;
            request.creationSourceType = this.creationSourceType;
            request.creationSourceDetails = this.creationSourceDetails;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.metadataEquals = this.metadataEquals;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsManagementAgentIdNull implements BmcEnum
    {
        True("true"),
        False("false");

        private final String value;
        private static Map<String, IsManagementAgentIdNull> map;

        private IsManagementAgentIdNull(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsManagementAgentIdNull create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsManagementAgentIdNull: " + key);
        }

        static {
            map = new HashMap<String, IsManagementAgentIdNull>();
            for (IsManagementAgentIdNull v : IsManagementAgentIdNull.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

