/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListLookupsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private Type type;
    private String lookupDisplayText;
    private IsSystem isSystem;
    private SortBy sortBy;
    private Status status;
    private String categories;
    private Boolean isHideSpecial;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public Type getType() {
        return this.type;
    }

    public String getLookupDisplayText() {
        return this.lookupDisplayText;
    }

    public IsSystem getIsSystem() {
        return this.isSystem;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getCategories() {
        return this.categories;
    }

    public Boolean getIsHideSpecial() {
        return this.isHideSpecial;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).type(this.type).lookupDisplayText(this.lookupDisplayText).isSystem(this.isSystem).sortBy(this.sortBy).status(this.status).categories(this.categories).isHideSpecial(this.isHideSpecial).limit(this.limit).page(this.page).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(",lookupDisplayText=").append(String.valueOf(this.lookupDisplayText));
        sb.append(",isSystem=").append(String.valueOf((Object)this.isSystem));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",status=").append(String.valueOf((Object)this.status));
        sb.append(",categories=").append(String.valueOf(this.categories));
        sb.append(",isHideSpecial=").append(String.valueOf(this.isHideSpecial));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListLookupsRequest)) {
            return false;
        }
        ListLookupsRequest other = (ListLookupsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.lookupDisplayText, other.lookupDisplayText) && Objects.equals((Object)this.isSystem, (Object)other.isSystem) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.categories, other.categories) && Objects.equals(this.isHideSpecial, other.isHideSpecial) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.lookupDisplayText == null ? 43 : this.lookupDisplayText.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.categories == null ? 43 : this.categories.hashCode());
        result = result * 59 + (this.isHideSpecial == null ? 43 : this.isHideSpecial.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListLookupsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private Type type = null;
        private String lookupDisplayText = null;
        private IsSystem isSystem = null;
        private SortBy sortBy = null;
        private Status status = null;
        private String categories = null;
        private Boolean isHideSpecial = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder lookupDisplayText(String lookupDisplayText) {
            this.lookupDisplayText = lookupDisplayText;
            return this;
        }

        public Builder isSystem(IsSystem isSystem) {
            this.isSystem = isSystem;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder categories(String categories) {
            this.categories = categories;
            return this;
        }

        public Builder isHideSpecial(Boolean isHideSpecial) {
            this.isHideSpecial = isHideSpecial;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListLookupsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.type(o.getType());
            this.lookupDisplayText(o.getLookupDisplayText());
            this.isSystem(o.getIsSystem());
            this.sortBy(o.getSortBy());
            this.status(o.getStatus());
            this.categories(o.getCategories());
            this.isHideSpecial(o.getIsHideSpecial());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListLookupsRequest build() {
            ListLookupsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListLookupsRequest buildWithoutInvocationCallback() {
            ListLookupsRequest request = new ListLookupsRequest();
            request.namespaceName = this.namespaceName;
            request.type = this.type;
            request.lookupDisplayText = this.lookupDisplayText;
            request.isSystem = this.isSystem;
            request.sortBy = this.sortBy;
            request.status = this.status;
            request.categories = this.categories;
            request.isHideSpecial = this.isHideSpecial;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        All("ALL"),
        Successful("SUCCESSFUL"),
        Failed("FAILED"),
        Inprogress("INPROGRESS");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DisplayName("displayName"),
        Status("status"),
        Type("type"),
        UpdatedTime("updatedTime"),
        CreationType("creationType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IsSystem implements BmcEnum
    {
        All("ALL"),
        Custom("CUSTOM"),
        BuiltIn("BUILT_IN");

        private final String value;
        private static Map<String, IsSystem> map;

        private IsSystem(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IsSystem create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IsSystem: " + key);
        }

        static {
            map = new HashMap<String, IsSystem>();
            for (IsSystem v : IsSystem.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Type implements BmcEnum
    {
        Lookup("Lookup"),
        Dictionary("Dictionary"),
        Module("Module");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

