/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.TaskType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListScheduledTasksRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private TaskType taskType;
    private String compartmentId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private String displayName;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String savedSearchId;
    private String displayNameContains;
    private String targetService;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getSavedSearchId() {
        return this.savedSearchId;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public String getTargetService() {
        return this.targetService;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).taskType(this.taskType).compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).displayName(this.displayName).sortOrder(this.sortOrder).sortBy(this.sortBy).savedSearchId(this.savedSearchId).displayNameContains(this.displayNameContains).targetService(this.targetService);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",taskType=").append(String.valueOf((Object)this.taskType));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",savedSearchId=").append(String.valueOf(this.savedSearchId));
        sb.append(",displayNameContains=").append(String.valueOf(this.displayNameContains));
        sb.append(",targetService=").append(String.valueOf(this.targetService));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListScheduledTasksRequest)) {
            return false;
        }
        ListScheduledTasksRequest other = (ListScheduledTasksRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.taskType, (Object)other.taskType) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.savedSearchId, other.savedSearchId) && Objects.equals(this.displayNameContains, other.displayNameContains) && Objects.equals(this.targetService, other.targetService);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.savedSearchId == null ? 43 : this.savedSearchId.hashCode());
        result = result * 59 + (this.displayNameContains == null ? 43 : this.displayNameContains.hashCode());
        result = result * 59 + (this.targetService == null ? 43 : this.targetService.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListScheduledTasksRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private TaskType taskType = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private String displayName = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String savedSearchId = null;
        private String displayNameContains = null;
        private String targetService = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder savedSearchId(String savedSearchId) {
            this.savedSearchId = savedSearchId;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder targetService(String targetService) {
            this.targetService = targetService;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListScheduledTasksRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.taskType(o.getTaskType());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.displayName(o.getDisplayName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.savedSearchId(o.getSavedSearchId());
            this.displayNameContains(o.getDisplayNameContains());
            this.targetService(o.getTargetService());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListScheduledTasksRequest build() {
            ListScheduledTasksRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListScheduledTasksRequest buildWithoutInvocationCallback() {
            ListScheduledTasksRequest request = new ListScheduledTasksRequest();
            request.namespaceName = this.namespaceName;
            request.taskType = this.taskType;
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.displayName = this.displayName;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.savedSearchId = this.savedSearchId;
            request.displayNameContains = this.displayNameContains;
            request.targetService = this.targetService;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

