/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.ReleaseRecalledDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ReleaseRecalledDataRequest
extends BmcRequest<ReleaseRecalledDataDetails> {
    private String namespaceName;
    private ReleaseRecalledDataDetails releaseRecalledDataDetails;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public ReleaseRecalledDataDetails getReleaseRecalledDataDetails() {
        return this.releaseRecalledDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public ReleaseRecalledDataDetails getBody$() {
        return this.releaseRecalledDataDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).releaseRecalledDataDetails(this.releaseRecalledDataDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",releaseRecalledDataDetails=").append(String.valueOf((Object)this.releaseRecalledDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReleaseRecalledDataRequest)) {
            return false;
        }
        ReleaseRecalledDataRequest other = (ReleaseRecalledDataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.releaseRecalledDataDetails, (Object)other.releaseRecalledDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.releaseRecalledDataDetails == null ? 43 : this.releaseRecalledDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ReleaseRecalledDataRequest, ReleaseRecalledDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private ReleaseRecalledDataDetails releaseRecalledDataDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder releaseRecalledDataDetails(ReleaseRecalledDataDetails releaseRecalledDataDetails) {
            this.releaseRecalledDataDetails = releaseRecalledDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ReleaseRecalledDataRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.releaseRecalledDataDetails(o.getReleaseRecalledDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ReleaseRecalledDataRequest build() {
            ReleaseRecalledDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ReleaseRecalledDataDetails body) {
            this.releaseRecalledDataDetails(body);
            return this;
        }

        public ReleaseRecalledDataRequest buildWithoutInvocationCallback() {
            ReleaseRecalledDataRequest request = new ReleaseRecalledDataRequest();
            request.namespaceName = this.namespaceName;
            request.releaseRecalledDataDetails = this.releaseRecalledDataDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

