/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class RunRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String scheduledTaskId;
    private Date timeStart;
    private Date timeEnd;
    private String opcRequestId;
    private String opcRetryToken;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).scheduledTaskId(this.scheduledTaskId).timeStart(this.timeStart).timeEnd(this.timeEnd).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",scheduledTaskId=").append(String.valueOf(this.scheduledTaskId));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RunRequest)) {
            return false;
        }
        RunRequest other = (RunRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.scheduledTaskId, other.scheduledTaskId) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.scheduledTaskId == null ? 43 : this.scheduledTaskId.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RunRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String scheduledTaskId = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder scheduledTaskId(String scheduledTaskId) {
            this.scheduledTaskId = scheduledTaskId;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RunRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.scheduledTaskId(o.getScheduledTaskId());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RunRequest build() {
            RunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RunRequest buildWithoutInvocationCallback() {
            RunRequest request = new RunRequest();
            request.namespaceName = this.namespaceName;
            request.scheduledTaskId = this.scheduledTaskId;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

