/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class UpdateLookupDataRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private String lookupName;
    private InputStream updateLookupFileBody;
    private Boolean isForce;
    private String charEncoding;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;
    private String expect;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public InputStream getUpdateLookupFileBody() {
        return this.updateLookupFileBody;
    }

    public Boolean getIsForce() {
        return this.isForce;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getExpect() {
        return this.expect;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.updateLookupFileBody;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).lookupName(this.lookupName).updateLookupFileBody(this.updateLookupFileBody).isForce(this.isForce).charEncoding(this.charEncoding).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).expect(this.expect);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",lookupName=").append(String.valueOf(this.lookupName));
        sb.append(",updateLookupFileBody=").append(String.valueOf(this.updateLookupFileBody));
        sb.append(",isForce=").append(String.valueOf(this.isForce));
        sb.append(",charEncoding=").append(String.valueOf(this.charEncoding));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",expect=").append(String.valueOf(this.expect));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateLookupDataRequest)) {
            return false;
        }
        UpdateLookupDataRequest other = (UpdateLookupDataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.lookupName, other.lookupName) && Objects.equals(this.updateLookupFileBody, other.updateLookupFileBody) && Objects.equals(this.isForce, other.isForce) && Objects.equals(this.charEncoding, other.charEncoding) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.expect, other.expect);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.lookupName == null ? 43 : this.lookupName.hashCode());
        result = result * 59 + (this.updateLookupFileBody == null ? 43 : this.updateLookupFileBody.hashCode());
        result = result * 59 + (this.isForce == null ? 43 : this.isForce.hashCode());
        result = result * 59 + (this.charEncoding == null ? 43 : this.charEncoding.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.expect == null ? 43 : this.expect.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateLookupDataRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String lookupName = null;
        private InputStream updateLookupFileBody = null;
        private Boolean isForce = null;
        private String charEncoding = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String expect = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder lookupName(String lookupName) {
            this.lookupName = lookupName;
            return this;
        }

        public Builder updateLookupFileBody(InputStream updateLookupFileBody) {
            this.updateLookupFileBody = updateLookupFileBody;
            return this;
        }

        public Builder isForce(Boolean isForce) {
            this.isForce = isForce;
            return this;
        }

        public Builder charEncoding(String charEncoding) {
            this.charEncoding = charEncoding;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateLookupDataRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.lookupName(o.getLookupName());
            this.updateLookupFileBody(o.getUpdateLookupFileBody());
            this.isForce(o.getIsForce());
            this.charEncoding(o.getCharEncoding());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.expect(o.getExpect());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateLookupDataRequest build() {
            UpdateLookupDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.updateLookupFileBody(body);
            return this;
        }

        public UpdateLookupDataRequest buildWithoutInvocationCallback() {
            UpdateLookupDataRequest request = new UpdateLookupDataRequest();
            request.namespaceName = this.namespaceName;
            request.lookupName = this.lookupName;
            request.updateLookupFileBody = this.updateLookupFileBody;
            request.isForce = this.isForce;
            request.charEncoding = this.charEncoding;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.expect = this.expect;
            return request;
        }
    }
}

