/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.PayloadType;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class UploadLogEventsFileRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private String logGroupId;
    private InputStream uploadLogEventsFileDetails;
    private String opcRequestId;
    private String logSet;
    private PayloadType payloadType;
    private String contentType;
    private String opcRetryToken;
    private String opcMetaProperties;
    private String expect;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public InputStream getUploadLogEventsFileDetails() {
        return this.uploadLogEventsFileDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getLogSet() {
        return this.logSet;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcMetaProperties() {
        return this.opcMetaProperties;
    }

    public String getExpect() {
        return this.expect;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.uploadLogEventsFileDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).logGroupId(this.logGroupId).uploadLogEventsFileDetails(this.uploadLogEventsFileDetails).opcRequestId(this.opcRequestId).logSet(this.logSet).payloadType(this.payloadType).contentType(this.contentType).opcRetryToken(this.opcRetryToken).opcMetaProperties(this.opcMetaProperties).expect(this.expect);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(",uploadLogEventsFileDetails=").append(String.valueOf(this.uploadLogEventsFileDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",logSet=").append(String.valueOf(this.logSet));
        sb.append(",payloadType=").append(String.valueOf((Object)this.payloadType));
        sb.append(",contentType=").append(String.valueOf(this.contentType));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcMetaProperties=").append(String.valueOf(this.opcMetaProperties));
        sb.append(",expect=").append(String.valueOf(this.expect));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadLogEventsFileRequest)) {
            return false;
        }
        UploadLogEventsFileRequest other = (UploadLogEventsFileRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals(this.uploadLogEventsFileDetails, other.uploadLogEventsFileDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.logSet, other.logSet) && Objects.equals((Object)this.payloadType, (Object)other.payloadType) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcMetaProperties, other.opcMetaProperties) && Objects.equals(this.expect, other.expect);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.uploadLogEventsFileDetails == null ? 43 : this.uploadLogEventsFileDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.logSet == null ? 43 : this.logSet.hashCode());
        result = result * 59 + (this.payloadType == null ? 43 : this.payloadType.hashCode());
        result = result * 59 + (this.contentType == null ? 43 : this.contentType.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcMetaProperties == null ? 43 : this.opcMetaProperties.hashCode());
        result = result * 59 + (this.expect == null ? 43 : this.expect.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UploadLogEventsFileRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String logGroupId = null;
        private InputStream uploadLogEventsFileDetails = null;
        private String opcRequestId = null;
        private String logSet = null;
        private PayloadType payloadType = null;
        private String contentType = null;
        private String opcRetryToken = null;
        private String opcMetaProperties = null;
        private String expect = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder uploadLogEventsFileDetails(InputStream uploadLogEventsFileDetails) {
            this.uploadLogEventsFileDetails = uploadLogEventsFileDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder logSet(String logSet) {
            this.logSet = logSet;
            return this;
        }

        public Builder payloadType(PayloadType payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcMetaProperties(String opcMetaProperties) {
            this.opcMetaProperties = opcMetaProperties;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadLogEventsFileRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.logGroupId(o.getLogGroupId());
            this.uploadLogEventsFileDetails(o.getUploadLogEventsFileDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.logSet(o.getLogSet());
            this.payloadType(o.getPayloadType());
            this.contentType(o.getContentType());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcMetaProperties(o.getOpcMetaProperties());
            this.expect(o.getExpect());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadLogEventsFileRequest build() {
            UploadLogEventsFileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.uploadLogEventsFileDetails(body);
            return this;
        }

        public UploadLogEventsFileRequest buildWithoutInvocationCallback() {
            UploadLogEventsFileRequest request = new UploadLogEventsFileRequest();
            request.namespaceName = this.namespaceName;
            request.logGroupId = this.logGroupId;
            request.uploadLogEventsFileDetails = this.uploadLogEventsFileDetails;
            request.opcRequestId = this.opcRequestId;
            request.logSet = this.logSet;
            request.payloadType = this.payloadType;
            request.contentType = this.contentType;
            request.opcRetryToken = this.opcRetryToken;
            request.opcMetaProperties = this.opcMetaProperties;
            request.expect = this.expect;
            return request;
        }
    }
}

