/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEndpoint;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidateEndpointRequest
extends BmcRequest<LogAnalyticsEndpoint> {
    private String namespaceName;
    private LogAnalyticsEndpoint validateEndpointDetails;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public LogAnalyticsEndpoint getValidateEndpointDetails() {
        return this.validateEndpointDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public LogAnalyticsEndpoint getBody$() {
        return this.validateEndpointDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).validateEndpointDetails(this.validateEndpointDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",validateEndpointDetails=").append(String.valueOf((Object)this.validateEndpointDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidateEndpointRequest)) {
            return false;
        }
        ValidateEndpointRequest other = (ValidateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.validateEndpointDetails, (Object)other.validateEndpointDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.validateEndpointDetails == null ? 43 : this.validateEndpointDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateEndpointRequest, LogAnalyticsEndpoint> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private LogAnalyticsEndpoint validateEndpointDetails = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder validateEndpointDetails(LogAnalyticsEndpoint validateEndpointDetails) {
            this.validateEndpointDetails = validateEndpointDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateEndpointRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.validateEndpointDetails(o.getValidateEndpointDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateEndpointRequest build() {
            ValidateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LogAnalyticsEndpoint body) {
            this.validateEndpointDetails(body);
            return this;
        }

        public ValidateEndpointRequest buildWithoutInvocationCallback() {
            ValidateEndpointRequest request = new ValidateEndpointRequest();
            request.namespaceName = this.namespaceName;
            request.validateEndpointDetails = this.validateEndpointDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

