/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class VerifyRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String scheduledTaskId;
    private Boolean shouldIncludeResults;
    private String opcRequestId;
    private String opcRetryToken;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getScheduledTaskId() {
        return this.scheduledTaskId;
    }

    public Boolean getShouldIncludeResults() {
        return this.shouldIncludeResults;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).scheduledTaskId(this.scheduledTaskId).shouldIncludeResults(this.shouldIncludeResults).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",scheduledTaskId=").append(String.valueOf(this.scheduledTaskId));
        sb.append(",shouldIncludeResults=").append(String.valueOf(this.shouldIncludeResults));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VerifyRequest)) {
            return false;
        }
        VerifyRequest other = (VerifyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.scheduledTaskId, other.scheduledTaskId) && Objects.equals(this.shouldIncludeResults, other.shouldIncludeResults) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.scheduledTaskId == null ? 43 : this.scheduledTaskId.hashCode());
        result = result * 59 + (this.shouldIncludeResults == null ? 43 : this.shouldIncludeResults.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<VerifyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String scheduledTaskId = null;
        private Boolean shouldIncludeResults = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder scheduledTaskId(String scheduledTaskId) {
            this.scheduledTaskId = scheduledTaskId;
            return this;
        }

        public Builder shouldIncludeResults(Boolean shouldIncludeResults) {
            this.shouldIncludeResults = shouldIncludeResults;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(VerifyRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.scheduledTaskId(o.getScheduledTaskId());
            this.shouldIncludeResults(o.getShouldIncludeResults());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public VerifyRequest build() {
            VerifyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public VerifyRequest buildWithoutInvocationCallback() {
            VerifyRequest request = new VerifyRequest();
            request.namespaceName = this.namespaceName;
            request.scheduledTaskId = this.scheduledTaskId;
            request.shouldIncludeResults = this.shouldIncludeResults;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

