/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssociableEntity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="entityTypeName")
    private final String entityTypeName;
    @JsonProperty(value="entityTypeDisplayName")
    private final String entityTypeDisplayName;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="eligibilityStatus")
    private final EligibilityStatus eligibilityStatus;
    @JsonProperty(value="ineligibilityDetails")
    private final String ineligibilityDetails;

    @Deprecated
    @ConstructorProperties(value={"entityId", "entityName", "entityTypeName", "entityTypeDisplayName", "host", "agentId", "eligibilityStatus", "ineligibilityDetails"})
    public AssociableEntity(String entityId, String entityName, String entityTypeName, String entityTypeDisplayName, String host, String agentId, EligibilityStatus eligibilityStatus, String ineligibilityDetails) {
        this.entityId = entityId;
        this.entityName = entityName;
        this.entityTypeName = entityTypeName;
        this.entityTypeDisplayName = entityTypeDisplayName;
        this.host = host;
        this.agentId = agentId;
        this.eligibilityStatus = eligibilityStatus;
        this.ineligibilityDetails = ineligibilityDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getEntityTypeDisplayName() {
        return this.entityTypeDisplayName;
    }

    public String getHost() {
        return this.host;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public EligibilityStatus getEligibilityStatus() {
        return this.eligibilityStatus;
    }

    public String getIneligibilityDetails() {
        return this.ineligibilityDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociableEntity(");
        sb.append("super=").append(super.toString());
        sb.append("entityId=").append(String.valueOf(this.entityId));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(", entityTypeName=").append(String.valueOf(this.entityTypeName));
        sb.append(", entityTypeDisplayName=").append(String.valueOf(this.entityTypeDisplayName));
        sb.append(", host=").append(String.valueOf(this.host));
        sb.append(", agentId=").append(String.valueOf(this.agentId));
        sb.append(", eligibilityStatus=").append(String.valueOf((Object)this.eligibilityStatus));
        sb.append(", ineligibilityDetails=").append(String.valueOf(this.ineligibilityDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociableEntity)) {
            return false;
        }
        AssociableEntity other = (AssociableEntity)((Object)o);
        return Objects.equals(this.entityId, other.entityId) && Objects.equals(this.entityName, other.entityName) && Objects.equals(this.entityTypeName, other.entityTypeName) && Objects.equals(this.entityTypeDisplayName, other.entityTypeDisplayName) && Objects.equals(this.host, other.host) && Objects.equals(this.agentId, other.agentId) && Objects.equals((Object)this.eligibilityStatus, (Object)other.eligibilityStatus) && Objects.equals(this.ineligibilityDetails, other.ineligibilityDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.entityTypeName == null ? 43 : this.entityTypeName.hashCode());
        result = result * 59 + (this.entityTypeDisplayName == null ? 43 : this.entityTypeDisplayName.hashCode());
        result = result * 59 + (this.host == null ? 43 : this.host.hashCode());
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.eligibilityStatus == null ? 43 : this.eligibilityStatus.hashCode());
        result = result * 59 + (this.ineligibilityDetails == null ? 43 : this.ineligibilityDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EligibilityStatus implements BmcEnum
    {
        Eligible("ELIGIBLE"),
        Ineligible("INELIGIBLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EligibilityStatus> map;

        private EligibilityStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EligibilityStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EligibilityStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EligibilityStatus.class);
            map = new HashMap<String, EligibilityStatus>();
            for (EligibilityStatus v : EligibilityStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="entityTypeName")
        private String entityTypeName;
        @JsonProperty(value="entityTypeDisplayName")
        private String entityTypeDisplayName;
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="eligibilityStatus")
        private EligibilityStatus eligibilityStatus;
        @JsonProperty(value="ineligibilityDetails")
        private String ineligibilityDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder entityTypeName(String entityTypeName) {
            this.entityTypeName = entityTypeName;
            this.__explicitlySet__.add("entityTypeName");
            return this;
        }

        public Builder entityTypeDisplayName(String entityTypeDisplayName) {
            this.entityTypeDisplayName = entityTypeDisplayName;
            this.__explicitlySet__.add("entityTypeDisplayName");
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            this.__explicitlySet__.add("host");
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder eligibilityStatus(EligibilityStatus eligibilityStatus) {
            this.eligibilityStatus = eligibilityStatus;
            this.__explicitlySet__.add("eligibilityStatus");
            return this;
        }

        public Builder ineligibilityDetails(String ineligibilityDetails) {
            this.ineligibilityDetails = ineligibilityDetails;
            this.__explicitlySet__.add("ineligibilityDetails");
            return this;
        }

        public AssociableEntity build() {
            AssociableEntity model = new AssociableEntity(this.entityId, this.entityName, this.entityTypeName, this.entityTypeDisplayName, this.host, this.agentId, this.eligibilityStatus, this.ineligibilityDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssociableEntity model) {
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("entityTypeName")) {
                this.entityTypeName(model.getEntityTypeName());
            }
            if (model.wasPropertyExplicitlySet("entityTypeDisplayName")) {
                this.entityTypeDisplayName(model.getEntityTypeDisplayName());
            }
            if (model.wasPropertyExplicitlySet("host")) {
                this.host(model.getHost());
            }
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("eligibilityStatus")) {
                this.eligibilityStatus(model.getEligibilityStatus());
            }
            if (model.wasPropertyExplicitlySet("ineligibilityDetails")) {
                this.ineligibilityDetails(model.getIneligibilityDetails());
            }
            return this;
        }
    }
}

