/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.Violation;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EndpointResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="endpointName")
    private final String endpointName;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="violations")
    private final List<Violation> violations;
    @JsonProperty(value="logEndpoints")
    private final List<String> logEndpoints;

    @Deprecated
    @ConstructorProperties(value={"endpointName", "url", "status", "violations", "logEndpoints"})
    public EndpointResult(String endpointName, String url, String status, List<Violation> violations, List<String> logEndpoints) {
        this.endpointName = endpointName;
        this.url = url;
        this.status = status;
        this.violations = violations;
        this.logEndpoints = logEndpoints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStatus() {
        return this.status;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public List<String> getLogEndpoints() {
        return this.logEndpoints;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EndpointResult(");
        sb.append("super=").append(super.toString());
        sb.append("endpointName=").append(String.valueOf(this.endpointName));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", violations=").append(String.valueOf(this.violations));
        sb.append(", logEndpoints=").append(String.valueOf(this.logEndpoints));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndpointResult)) {
            return false;
        }
        EndpointResult other = (EndpointResult)((Object)o);
        return Objects.equals(this.endpointName, other.endpointName) && Objects.equals(this.url, other.url) && Objects.equals(this.status, other.status) && Objects.equals(this.violations, other.violations) && Objects.equals(this.logEndpoints, other.logEndpoints) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.endpointName == null ? 43 : this.endpointName.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.violations == null ? 43 : this.violations.hashCode());
        result = result * 59 + (this.logEndpoints == null ? 43 : this.logEndpoints.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="endpointName")
        private String endpointName;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="violations")
        private List<Violation> violations;
        @JsonProperty(value="logEndpoints")
        private List<String> logEndpoints;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            this.__explicitlySet__.add("endpointName");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder violations(List<Violation> violations) {
            this.violations = violations;
            this.__explicitlySet__.add("violations");
            return this;
        }

        public Builder logEndpoints(List<String> logEndpoints) {
            this.logEndpoints = logEndpoints;
            this.__explicitlySet__.add("logEndpoints");
            return this;
        }

        public EndpointResult build() {
            EndpointResult model = new EndpointResult(this.endpointName, this.url, this.status, this.violations, this.logEndpoints);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EndpointResult model) {
            if (model.wasPropertyExplicitlySet("endpointName")) {
                this.endpointName(model.getEndpointName());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("violations")) {
                this.violations(model.getViolations());
            }
            if (model.wasPropertyExplicitlySet("logEndpoints")) {
                this.logEndpoints(model.getLogEndpoints());
            }
            return this;
        }
    }
}

