/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsAssociatedEntity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="entityTypeDisplayName")
    private final String entityTypeDisplayName;
    @JsonProperty(value="onHost")
    private final String onHost;
    @JsonProperty(value="associationCount")
    private final Long associationCount;

    @Deprecated
    @ConstructorProperties(value={"entityId", "entityName", "entityType", "entityTypeDisplayName", "onHost", "associationCount"})
    public LogAnalyticsAssociatedEntity(String entityId, String entityName, String entityType, String entityTypeDisplayName, String onHost, Long associationCount) {
        this.entityId = entityId;
        this.entityName = entityName;
        this.entityType = entityType;
        this.entityTypeDisplayName = entityTypeDisplayName;
        this.onHost = onHost;
        this.associationCount = associationCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityTypeDisplayName() {
        return this.entityTypeDisplayName;
    }

    public String getOnHost() {
        return this.onHost;
    }

    public Long getAssociationCount() {
        return this.associationCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsAssociatedEntity(");
        sb.append("super=").append(super.toString());
        sb.append("entityId=").append(String.valueOf(this.entityId));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", entityTypeDisplayName=").append(String.valueOf(this.entityTypeDisplayName));
        sb.append(", onHost=").append(String.valueOf(this.onHost));
        sb.append(", associationCount=").append(String.valueOf(this.associationCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsAssociatedEntity)) {
            return false;
        }
        LogAnalyticsAssociatedEntity other = (LogAnalyticsAssociatedEntity)((Object)o);
        return Objects.equals(this.entityId, other.entityId) && Objects.equals(this.entityName, other.entityName) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.entityTypeDisplayName, other.entityTypeDisplayName) && Objects.equals(this.onHost, other.onHost) && Objects.equals(this.associationCount, other.associationCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.entityTypeDisplayName == null ? 43 : this.entityTypeDisplayName.hashCode());
        result = result * 59 + (this.onHost == null ? 43 : this.onHost.hashCode());
        result = result * 59 + (this.associationCount == null ? 43 : this.associationCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="entityTypeDisplayName")
        private String entityTypeDisplayName;
        @JsonProperty(value="onHost")
        private String onHost;
        @JsonProperty(value="associationCount")
        private Long associationCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder entityTypeDisplayName(String entityTypeDisplayName) {
            this.entityTypeDisplayName = entityTypeDisplayName;
            this.__explicitlySet__.add("entityTypeDisplayName");
            return this;
        }

        public Builder onHost(String onHost) {
            this.onHost = onHost;
            this.__explicitlySet__.add("onHost");
            return this;
        }

        public Builder associationCount(Long associationCount) {
            this.associationCount = associationCount;
            this.__explicitlySet__.add("associationCount");
            return this;
        }

        public LogAnalyticsAssociatedEntity build() {
            LogAnalyticsAssociatedEntity model = new LogAnalyticsAssociatedEntity(this.entityId, this.entityName, this.entityType, this.entityTypeDisplayName, this.onHost, this.associationCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsAssociatedEntity model) {
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("entityTypeDisplayName")) {
                this.entityTypeDisplayName(model.getEntityTypeDisplayName());
            }
            if (model.wasPropertyExplicitlySet("onHost")) {
                this.onHost(model.getOnHost());
            }
            if (model.wasPropertyExplicitlySet("associationCount")) {
                this.associationCount(model.getAssociationCount());
            }
            return this;
        }
    }
}

