/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.LogAnalyticsMetaFunction;
import com.oracle.bmc.loganalytics.model.LogAnalyticsMetaFunctionArgument;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsSourceFunction
extends ExplicitlySetBmcModel {
    @JsonProperty(value="arguments")
    private final List<LogAnalyticsMetaFunctionArgument> arguments;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="function")
    private final LogAnalyticsMetaFunction function;
    @JsonProperty(value="functionName")
    private final FunctionName functionName;
    @JsonProperty(value="functionReference")
    private final String functionReference;
    @JsonProperty(value="sourceReference")
    private final String sourceReference;
    @JsonProperty(value="features")
    private final List<String> features;
    @JsonProperty(value="functionId")
    private final Long functionId;
    @JsonProperty(value="order")
    private final Long order;
    @JsonProperty(value="isSystem")
    private final Boolean isSystem;
    @JsonProperty(value="lookupColumn")
    private final String lookupColumn;
    @JsonProperty(value="lookupColumnPosition")
    private final Long lookupColumnPosition;
    @JsonProperty(value="lookupDisplayName")
    private final String lookupDisplayName;
    @JsonProperty(value="lookupMode")
    private final Long lookupMode;
    @JsonProperty(value="lookupTable")
    private final String lookupTable;
    @JsonProperty(value="sourceId")
    private final Long sourceId;

    @Deprecated
    @ConstructorProperties(value={"arguments", "isEnabled", "function", "functionName", "functionReference", "sourceReference", "features", "functionId", "order", "isSystem", "lookupColumn", "lookupColumnPosition", "lookupDisplayName", "lookupMode", "lookupTable", "sourceId"})
    public LogAnalyticsSourceFunction(List<LogAnalyticsMetaFunctionArgument> arguments, Boolean isEnabled, LogAnalyticsMetaFunction function, FunctionName functionName, String functionReference, String sourceReference, List<String> features, Long functionId, Long order, Boolean isSystem, String lookupColumn, Long lookupColumnPosition, String lookupDisplayName, Long lookupMode, String lookupTable, Long sourceId) {
        this.arguments = arguments;
        this.isEnabled = isEnabled;
        this.function = function;
        this.functionName = functionName;
        this.functionReference = functionReference;
        this.sourceReference = sourceReference;
        this.features = features;
        this.functionId = functionId;
        this.order = order;
        this.isSystem = isSystem;
        this.lookupColumn = lookupColumn;
        this.lookupColumnPosition = lookupColumnPosition;
        this.lookupDisplayName = lookupDisplayName;
        this.lookupMode = lookupMode;
        this.lookupTable = lookupTable;
        this.sourceId = sourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<LogAnalyticsMetaFunctionArgument> getArguments() {
        return this.arguments;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public LogAnalyticsMetaFunction getFunction() {
        return this.function;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public String getFunctionReference() {
        return this.functionReference;
    }

    public String getSourceReference() {
        return this.sourceReference;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public Long getFunctionId() {
        return this.functionId;
    }

    public Long getOrder() {
        return this.order;
    }

    public Boolean getIsSystem() {
        return this.isSystem;
    }

    public String getLookupColumn() {
        return this.lookupColumn;
    }

    public Long getLookupColumnPosition() {
        return this.lookupColumnPosition;
    }

    public String getLookupDisplayName() {
        return this.lookupDisplayName;
    }

    public Long getLookupMode() {
        return this.lookupMode;
    }

    public String getLookupTable() {
        return this.lookupTable;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsSourceFunction(");
        sb.append("super=").append(super.toString());
        sb.append("arguments=").append(String.valueOf(this.arguments));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", function=").append(String.valueOf((Object)this.function));
        sb.append(", functionName=").append(String.valueOf((Object)this.functionName));
        sb.append(", functionReference=").append(String.valueOf(this.functionReference));
        sb.append(", sourceReference=").append(String.valueOf(this.sourceReference));
        sb.append(", features=").append(String.valueOf(this.features));
        sb.append(", functionId=").append(String.valueOf(this.functionId));
        sb.append(", order=").append(String.valueOf(this.order));
        sb.append(", isSystem=").append(String.valueOf(this.isSystem));
        sb.append(", lookupColumn=").append(String.valueOf(this.lookupColumn));
        sb.append(", lookupColumnPosition=").append(String.valueOf(this.lookupColumnPosition));
        sb.append(", lookupDisplayName=").append(String.valueOf(this.lookupDisplayName));
        sb.append(", lookupMode=").append(String.valueOf(this.lookupMode));
        sb.append(", lookupTable=").append(String.valueOf(this.lookupTable));
        sb.append(", sourceId=").append(String.valueOf(this.sourceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsSourceFunction)) {
            return false;
        }
        LogAnalyticsSourceFunction other = (LogAnalyticsSourceFunction)((Object)o);
        return Objects.equals(this.arguments, other.arguments) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.function, (Object)other.function) && Objects.equals((Object)this.functionName, (Object)other.functionName) && Objects.equals(this.functionReference, other.functionReference) && Objects.equals(this.sourceReference, other.sourceReference) && Objects.equals(this.features, other.features) && Objects.equals(this.functionId, other.functionId) && Objects.equals(this.order, other.order) && Objects.equals(this.isSystem, other.isSystem) && Objects.equals(this.lookupColumn, other.lookupColumn) && Objects.equals(this.lookupColumnPosition, other.lookupColumnPosition) && Objects.equals(this.lookupDisplayName, other.lookupDisplayName) && Objects.equals(this.lookupMode, other.lookupMode) && Objects.equals(this.lookupTable, other.lookupTable) && Objects.equals(this.sourceId, other.sourceId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.arguments == null ? 43 : this.arguments.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.function == null ? 43 : this.function.hashCode());
        result = result * 59 + (this.functionName == null ? 43 : this.functionName.hashCode());
        result = result * 59 + (this.functionReference == null ? 43 : this.functionReference.hashCode());
        result = result * 59 + (this.sourceReference == null ? 43 : this.sourceReference.hashCode());
        result = result * 59 + (this.features == null ? 43 : this.features.hashCode());
        result = result * 59 + (this.functionId == null ? 43 : this.functionId.hashCode());
        result = result * 59 + (this.order == null ? 43 : this.order.hashCode());
        result = result * 59 + (this.isSystem == null ? 43 : this.isSystem.hashCode());
        result = result * 59 + (this.lookupColumn == null ? 43 : this.lookupColumn.hashCode());
        result = result * 59 + (this.lookupColumnPosition == null ? 43 : this.lookupColumnPosition.hashCode());
        result = result * 59 + (this.lookupDisplayName == null ? 43 : this.lookupDisplayName.hashCode());
        result = result * 59 + (this.lookupMode == null ? 43 : this.lookupMode.hashCode());
        result = result * 59 + (this.lookupTable == null ? 43 : this.lookupTable.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum FunctionName implements BmcEnum
    {
        Geolocation("GEOLOCATION"),
        Lookup("LOOKUP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FunctionName> map;

        private FunctionName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FunctionName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FunctionName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FunctionName.class);
            map = new HashMap<String, FunctionName>();
            for (FunctionName v : FunctionName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="arguments")
        private List<LogAnalyticsMetaFunctionArgument> arguments;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="function")
        private LogAnalyticsMetaFunction function;
        @JsonProperty(value="functionName")
        private FunctionName functionName;
        @JsonProperty(value="functionReference")
        private String functionReference;
        @JsonProperty(value="sourceReference")
        private String sourceReference;
        @JsonProperty(value="features")
        private List<String> features;
        @JsonProperty(value="functionId")
        private Long functionId;
        @JsonProperty(value="order")
        private Long order;
        @JsonProperty(value="isSystem")
        private Boolean isSystem;
        @JsonProperty(value="lookupColumn")
        private String lookupColumn;
        @JsonProperty(value="lookupColumnPosition")
        private Long lookupColumnPosition;
        @JsonProperty(value="lookupDisplayName")
        private String lookupDisplayName;
        @JsonProperty(value="lookupMode")
        private Long lookupMode;
        @JsonProperty(value="lookupTable")
        private String lookupTable;
        @JsonProperty(value="sourceId")
        private Long sourceId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder arguments(List<LogAnalyticsMetaFunctionArgument> arguments) {
            this.arguments = arguments;
            this.__explicitlySet__.add("arguments");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder function(LogAnalyticsMetaFunction function) {
            this.function = function;
            this.__explicitlySet__.add("function");
            return this;
        }

        public Builder functionName(FunctionName functionName) {
            this.functionName = functionName;
            this.__explicitlySet__.add("functionName");
            return this;
        }

        public Builder functionReference(String functionReference) {
            this.functionReference = functionReference;
            this.__explicitlySet__.add("functionReference");
            return this;
        }

        public Builder sourceReference(String sourceReference) {
            this.sourceReference = sourceReference;
            this.__explicitlySet__.add("sourceReference");
            return this;
        }

        public Builder features(List<String> features) {
            this.features = features;
            this.__explicitlySet__.add("features");
            return this;
        }

        public Builder functionId(Long functionId) {
            this.functionId = functionId;
            this.__explicitlySet__.add("functionId");
            return this;
        }

        public Builder order(Long order) {
            this.order = order;
            this.__explicitlySet__.add("order");
            return this;
        }

        public Builder isSystem(Boolean isSystem) {
            this.isSystem = isSystem;
            this.__explicitlySet__.add("isSystem");
            return this;
        }

        public Builder lookupColumn(String lookupColumn) {
            this.lookupColumn = lookupColumn;
            this.__explicitlySet__.add("lookupColumn");
            return this;
        }

        public Builder lookupColumnPosition(Long lookupColumnPosition) {
            this.lookupColumnPosition = lookupColumnPosition;
            this.__explicitlySet__.add("lookupColumnPosition");
            return this;
        }

        public Builder lookupDisplayName(String lookupDisplayName) {
            this.lookupDisplayName = lookupDisplayName;
            this.__explicitlySet__.add("lookupDisplayName");
            return this;
        }

        public Builder lookupMode(Long lookupMode) {
            this.lookupMode = lookupMode;
            this.__explicitlySet__.add("lookupMode");
            return this;
        }

        public Builder lookupTable(String lookupTable) {
            this.lookupTable = lookupTable;
            this.__explicitlySet__.add("lookupTable");
            return this;
        }

        public Builder sourceId(Long sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public LogAnalyticsSourceFunction build() {
            LogAnalyticsSourceFunction model = new LogAnalyticsSourceFunction(this.arguments, this.isEnabled, this.function, this.functionName, this.functionReference, this.sourceReference, this.features, this.functionId, this.order, this.isSystem, this.lookupColumn, this.lookupColumnPosition, this.lookupDisplayName, this.lookupMode, this.lookupTable, this.sourceId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsSourceFunction model) {
            if (model.wasPropertyExplicitlySet("arguments")) {
                this.arguments(model.getArguments());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("function")) {
                this.function(model.getFunction());
            }
            if (model.wasPropertyExplicitlySet("functionName")) {
                this.functionName(model.getFunctionName());
            }
            if (model.wasPropertyExplicitlySet("functionReference")) {
                this.functionReference(model.getFunctionReference());
            }
            if (model.wasPropertyExplicitlySet("sourceReference")) {
                this.sourceReference(model.getSourceReference());
            }
            if (model.wasPropertyExplicitlySet("features")) {
                this.features(model.getFeatures());
            }
            if (model.wasPropertyExplicitlySet("functionId")) {
                this.functionId(model.getFunctionId());
            }
            if (model.wasPropertyExplicitlySet("order")) {
                this.order(model.getOrder());
            }
            if (model.wasPropertyExplicitlySet("isSystem")) {
                this.isSystem(model.getIsSystem());
            }
            if (model.wasPropertyExplicitlySet("lookupColumn")) {
                this.lookupColumn(model.getLookupColumn());
            }
            if (model.wasPropertyExplicitlySet("lookupColumnPosition")) {
                this.lookupColumnPosition(model.getLookupColumnPosition());
            }
            if (model.wasPropertyExplicitlySet("lookupDisplayName")) {
                this.lookupDisplayName(model.getLookupDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lookupMode")) {
                this.lookupMode(model.getLookupMode());
            }
            if (model.wasPropertyExplicitlySet("lookupTable")) {
                this.lookupTable(model.getLookupTable());
            }
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            return this;
        }
    }
}

