/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PropertyOverride
extends ExplicitlySetBmcModel {
    @JsonProperty(value="matchType")
    private final String matchType;
    @JsonProperty(value="matchValue")
    private final String matchValue;
    @JsonProperty(value="propertyName")
    private final String propertyName;
    @JsonProperty(value="propertyValue")
    private final String propertyValue;

    @Deprecated
    @ConstructorProperties(value={"matchType", "matchValue", "propertyName", "propertyValue"})
    public PropertyOverride(String matchType, String matchValue, String propertyName, String propertyValue) {
        this.matchType = matchType;
        this.matchValue = matchValue;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getMatchType() {
        return this.matchType;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyOverride(");
        sb.append("super=").append(super.toString());
        sb.append("matchType=").append(String.valueOf(this.matchType));
        sb.append(", matchValue=").append(String.valueOf(this.matchValue));
        sb.append(", propertyName=").append(String.valueOf(this.propertyName));
        sb.append(", propertyValue=").append(String.valueOf(this.propertyValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyOverride)) {
            return false;
        }
        PropertyOverride other = (PropertyOverride)((Object)o);
        return Objects.equals(this.matchType, other.matchType) && Objects.equals(this.matchValue, other.matchValue) && Objects.equals(this.propertyName, other.propertyName) && Objects.equals(this.propertyValue, other.propertyValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.matchType == null ? 43 : this.matchType.hashCode());
        result = result * 59 + (this.matchValue == null ? 43 : this.matchValue.hashCode());
        result = result * 59 + (this.propertyName == null ? 43 : this.propertyName.hashCode());
        result = result * 59 + (this.propertyValue == null ? 43 : this.propertyValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="matchType")
        private String matchType;
        @JsonProperty(value="matchValue")
        private String matchValue;
        @JsonProperty(value="propertyName")
        private String propertyName;
        @JsonProperty(value="propertyValue")
        private String propertyValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder matchType(String matchType) {
            this.matchType = matchType;
            this.__explicitlySet__.add("matchType");
            return this;
        }

        public Builder matchValue(String matchValue) {
            this.matchValue = matchValue;
            this.__explicitlySet__.add("matchValue");
            return this;
        }

        public Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            this.__explicitlySet__.add("propertyName");
            return this;
        }

        public Builder propertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
            this.__explicitlySet__.add("propertyValue");
            return this;
        }

        public PropertyOverride build() {
            PropertyOverride model = new PropertyOverride(this.matchType, this.matchValue, this.propertyName, this.propertyValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PropertyOverride model) {
            if (model.wasPropertyExplicitlySet("matchType")) {
                this.matchType(model.getMatchType());
            }
            if (model.wasPropertyExplicitlySet("matchValue")) {
                this.matchValue(model.getMatchValue());
            }
            if (model.wasPropertyExplicitlySet("propertyName")) {
                this.propertyName(model.getPropertyName());
            }
            if (model.wasPropertyExplicitlySet("propertyValue")) {
                this.propertyValue(model.getPropertyValue());
            }
            return this;
        }
    }
}

