/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UploadFileSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="reference")
    private final String reference;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="totalChunks")
    private final BigDecimal totalChunks;
    @JsonProperty(value="chunksConsumed")
    private final BigDecimal chunksConsumed;
    @JsonProperty(value="chunksSuccess")
    private final BigDecimal chunksSuccess;
    @JsonProperty(value="chunksFail")
    private final BigDecimal chunksFail;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="sourceName")
    private final String sourceName;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="entityName")
    private final String entityName;
    @JsonProperty(value="logNamespace")
    private final String logNamespace;
    @JsonProperty(value="logGroupId")
    private final String logGroupId;
    @JsonProperty(value="logGroupName")
    private final String logGroupName;
    @JsonProperty(value="failureDetails")
    private final String failureDetails;

    @Deprecated
    @ConstructorProperties(value={"reference", "name", "status", "totalChunks", "chunksConsumed", "chunksSuccess", "chunksFail", "timeStarted", "sourceName", "entityType", "entityName", "logNamespace", "logGroupId", "logGroupName", "failureDetails"})
    public UploadFileSummary(String reference, String name, Status status, BigDecimal totalChunks, BigDecimal chunksConsumed, BigDecimal chunksSuccess, BigDecimal chunksFail, Date timeStarted, String sourceName, String entityType, String entityName, String logNamespace, String logGroupId, String logGroupName, String failureDetails) {
        this.reference = reference;
        this.name = name;
        this.status = status;
        this.totalChunks = totalChunks;
        this.chunksConsumed = chunksConsumed;
        this.chunksSuccess = chunksSuccess;
        this.chunksFail = chunksFail;
        this.timeStarted = timeStarted;
        this.sourceName = sourceName;
        this.entityType = entityType;
        this.entityName = entityName;
        this.logNamespace = logNamespace;
        this.logGroupId = logGroupId;
        this.logGroupName = logGroupName;
        this.failureDetails = failureDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getReference() {
        return this.reference;
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public BigDecimal getTotalChunks() {
        return this.totalChunks;
    }

    public BigDecimal getChunksConsumed() {
        return this.chunksConsumed;
    }

    public BigDecimal getChunksSuccess() {
        return this.chunksSuccess;
    }

    public BigDecimal getChunksFail() {
        return this.chunksFail;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getLogNamespace() {
        return this.logNamespace;
    }

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public String getFailureDetails() {
        return this.failureDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UploadFileSummary(");
        sb.append("super=").append(super.toString());
        sb.append("reference=").append(String.valueOf(this.reference));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", totalChunks=").append(String.valueOf(this.totalChunks));
        sb.append(", chunksConsumed=").append(String.valueOf(this.chunksConsumed));
        sb.append(", chunksSuccess=").append(String.valueOf(this.chunksSuccess));
        sb.append(", chunksFail=").append(String.valueOf(this.chunksFail));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", sourceName=").append(String.valueOf(this.sourceName));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", entityName=").append(String.valueOf(this.entityName));
        sb.append(", logNamespace=").append(String.valueOf(this.logNamespace));
        sb.append(", logGroupId=").append(String.valueOf(this.logGroupId));
        sb.append(", logGroupName=").append(String.valueOf(this.logGroupName));
        sb.append(", failureDetails=").append(String.valueOf(this.failureDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadFileSummary)) {
            return false;
        }
        UploadFileSummary other = (UploadFileSummary)((Object)o);
        return Objects.equals(this.reference, other.reference) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.totalChunks, other.totalChunks) && Objects.equals(this.chunksConsumed, other.chunksConsumed) && Objects.equals(this.chunksSuccess, other.chunksSuccess) && Objects.equals(this.chunksFail, other.chunksFail) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.sourceName, other.sourceName) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.entityName, other.entityName) && Objects.equals(this.logNamespace, other.logNamespace) && Objects.equals(this.logGroupId, other.logGroupId) && Objects.equals(this.logGroupName, other.logGroupName) && Objects.equals(this.failureDetails, other.failureDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.reference == null ? 43 : this.reference.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.totalChunks == null ? 43 : this.totalChunks.hashCode());
        result = result * 59 + (this.chunksConsumed == null ? 43 : this.chunksConsumed.hashCode());
        result = result * 59 + (this.chunksSuccess == null ? 43 : this.chunksSuccess.hashCode());
        result = result * 59 + (this.chunksFail == null ? 43 : this.chunksFail.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.sourceName == null ? 43 : this.sourceName.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.entityName == null ? 43 : this.entityName.hashCode());
        result = result * 59 + (this.logNamespace == null ? 43 : this.logNamespace.hashCode());
        result = result * 59 + (this.logGroupId == null ? 43 : this.logGroupId.hashCode());
        result = result * 59 + (this.logGroupName == null ? 43 : this.logGroupName.hashCode());
        result = result * 59 + (this.failureDetails == null ? 43 : this.failureDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        InProgress("IN_PROGRESS"),
        Successful("SUCCESSFUL"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="reference")
        private String reference;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="totalChunks")
        private BigDecimal totalChunks;
        @JsonProperty(value="chunksConsumed")
        private BigDecimal chunksConsumed;
        @JsonProperty(value="chunksSuccess")
        private BigDecimal chunksSuccess;
        @JsonProperty(value="chunksFail")
        private BigDecimal chunksFail;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="sourceName")
        private String sourceName;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="entityName")
        private String entityName;
        @JsonProperty(value="logNamespace")
        private String logNamespace;
        @JsonProperty(value="logGroupId")
        private String logGroupId;
        @JsonProperty(value="logGroupName")
        private String logGroupName;
        @JsonProperty(value="failureDetails")
        private String failureDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder reference(String reference) {
            this.reference = reference;
            this.__explicitlySet__.add("reference");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder totalChunks(BigDecimal totalChunks) {
            this.totalChunks = totalChunks;
            this.__explicitlySet__.add("totalChunks");
            return this;
        }

        public Builder chunksConsumed(BigDecimal chunksConsumed) {
            this.chunksConsumed = chunksConsumed;
            this.__explicitlySet__.add("chunksConsumed");
            return this;
        }

        public Builder chunksSuccess(BigDecimal chunksSuccess) {
            this.chunksSuccess = chunksSuccess;
            this.__explicitlySet__.add("chunksSuccess");
            return this;
        }

        public Builder chunksFail(BigDecimal chunksFail) {
            this.chunksFail = chunksFail;
            this.__explicitlySet__.add("chunksFail");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            this.__explicitlySet__.add("sourceName");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.__explicitlySet__.add("entityName");
            return this;
        }

        public Builder logNamespace(String logNamespace) {
            this.logNamespace = logNamespace;
            this.__explicitlySet__.add("logNamespace");
            return this;
        }

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            this.__explicitlySet__.add("logGroupId");
            return this;
        }

        public Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            this.__explicitlySet__.add("logGroupName");
            return this;
        }

        public Builder failureDetails(String failureDetails) {
            this.failureDetails = failureDetails;
            this.__explicitlySet__.add("failureDetails");
            return this;
        }

        public UploadFileSummary build() {
            UploadFileSummary model = new UploadFileSummary(this.reference, this.name, this.status, this.totalChunks, this.chunksConsumed, this.chunksSuccess, this.chunksFail, this.timeStarted, this.sourceName, this.entityType, this.entityName, this.logNamespace, this.logGroupId, this.logGroupName, this.failureDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UploadFileSummary model) {
            if (model.wasPropertyExplicitlySet("reference")) {
                this.reference(model.getReference());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("totalChunks")) {
                this.totalChunks(model.getTotalChunks());
            }
            if (model.wasPropertyExplicitlySet("chunksConsumed")) {
                this.chunksConsumed(model.getChunksConsumed());
            }
            if (model.wasPropertyExplicitlySet("chunksSuccess")) {
                this.chunksSuccess(model.getChunksSuccess());
            }
            if (model.wasPropertyExplicitlySet("chunksFail")) {
                this.chunksFail(model.getChunksFail());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("sourceName")) {
                this.sourceName(model.getSourceName());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("entityName")) {
                this.entityName(model.getEntityName());
            }
            if (model.wasPropertyExplicitlySet("logNamespace")) {
                this.logNamespace(model.getLogNamespace());
            }
            if (model.wasPropertyExplicitlySet("logGroupId")) {
                this.logGroupId(model.getLogGroupId());
            }
            if (model.wasPropertyExplicitlySet("logGroupName")) {
                this.logGroupName(model.getLogGroupName());
            }
            if (model.wasPropertyExplicitlySet("failureDetails")) {
                this.failureDetails(model.getFailureDetails());
            }
            return this;
        }
    }
}

