/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.EstimateRecallDataSizeDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class EstimateRecallDataSizeRequest
extends BmcRequest<EstimateRecallDataSizeDetails> {
    private String namespaceName;
    private EstimateRecallDataSizeDetails estimateRecallDataSizeDetails;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public EstimateRecallDataSizeDetails getEstimateRecallDataSizeDetails() {
        return this.estimateRecallDataSizeDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public EstimateRecallDataSizeDetails getBody$() {
        return this.estimateRecallDataSizeDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).estimateRecallDataSizeDetails(this.estimateRecallDataSizeDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",estimateRecallDataSizeDetails=").append(String.valueOf((Object)this.estimateRecallDataSizeDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EstimateRecallDataSizeRequest)) {
            return false;
        }
        EstimateRecallDataSizeRequest other = (EstimateRecallDataSizeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.estimateRecallDataSizeDetails, (Object)other.estimateRecallDataSizeDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.estimateRecallDataSizeDetails == null ? 43 : this.estimateRecallDataSizeDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<EstimateRecallDataSizeRequest, EstimateRecallDataSizeDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private EstimateRecallDataSizeDetails estimateRecallDataSizeDetails = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder estimateRecallDataSizeDetails(EstimateRecallDataSizeDetails estimateRecallDataSizeDetails) {
            this.estimateRecallDataSizeDetails = estimateRecallDataSizeDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(EstimateRecallDataSizeRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.estimateRecallDataSizeDetails(o.getEstimateRecallDataSizeDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public EstimateRecallDataSizeRequest build() {
            EstimateRecallDataSizeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(EstimateRecallDataSizeDetails body) {
            this.estimateRecallDataSizeDetails(body);
            return this;
        }

        public EstimateRecallDataSizeRequest buildWithoutInvocationCallback() {
            EstimateRecallDataSizeRequest request = new EstimateRecallDataSizeRequest();
            request.namespaceName = this.namespaceName;
            request.estimateRecallDataSizeDetails = this.estimateRecallDataSizeDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

