/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.ParseQueryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ParseQueryRequest
extends BmcRequest<ParseQueryDetails> {
    private String namespaceName;
    private ParseQueryDetails parseQueryDetails;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public ParseQueryDetails getParseQueryDetails() {
        return this.parseQueryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ParseQueryDetails getBody$() {
        return this.parseQueryDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).parseQueryDetails(this.parseQueryDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",parseQueryDetails=").append(String.valueOf((Object)this.parseQueryDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParseQueryRequest)) {
            return false;
        }
        ParseQueryRequest other = (ParseQueryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.parseQueryDetails, (Object)other.parseQueryDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.parseQueryDetails == null ? 43 : this.parseQueryDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ParseQueryRequest, ParseQueryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private ParseQueryDetails parseQueryDetails = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder parseQueryDetails(ParseQueryDetails parseQueryDetails) {
            this.parseQueryDetails = parseQueryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ParseQueryRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.parseQueryDetails(o.getParseQueryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ParseQueryRequest build() {
            ParseQueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ParseQueryDetails body) {
            this.parseQueryDetails(body);
            return this;
        }

        public ParseQueryRequest buildWithoutInvocationCallback() {
            ParseQueryRequest request = new ParseQueryRequest();
            request.namespaceName = this.namespaceName;
            request.parseQueryDetails = this.parseQueryDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

