/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.ValidateLabelConditionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidateLabelConditionRequest
extends BmcRequest<ValidateLabelConditionDetails> {
    private String namespaceName;
    private ValidateLabelConditionDetails validateLabelConditionDetails;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public ValidateLabelConditionDetails getValidateLabelConditionDetails() {
        return this.validateLabelConditionDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ValidateLabelConditionDetails getBody$() {
        return this.validateLabelConditionDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).validateLabelConditionDetails(this.validateLabelConditionDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",validateLabelConditionDetails=").append(String.valueOf((Object)this.validateLabelConditionDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidateLabelConditionRequest)) {
            return false;
        }
        ValidateLabelConditionRequest other = (ValidateLabelConditionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.validateLabelConditionDetails, (Object)other.validateLabelConditionDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.validateLabelConditionDetails == null ? 43 : this.validateLabelConditionDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateLabelConditionRequest, ValidateLabelConditionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private ValidateLabelConditionDetails validateLabelConditionDetails = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder validateLabelConditionDetails(ValidateLabelConditionDetails validateLabelConditionDetails) {
            this.validateLabelConditionDetails = validateLabelConditionDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateLabelConditionRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.validateLabelConditionDetails(o.getValidateLabelConditionDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateLabelConditionRequest build() {
            ValidateLabelConditionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ValidateLabelConditionDetails body) {
            this.validateLabelConditionDetails(body);
            return this;
        }

        public ValidateLabelConditionRequest buildWithoutInvocationCallback() {
            ValidateLabelConditionRequest request = new ValidateLabelConditionRequest();
            request.namespaceName = this.namespaceName;
            request.validateLabelConditionDetails = this.validateLabelConditionDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

