/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.IngestTimeRuleAction;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class IngestTimeRuleMetricExtractionAction
extends IngestTimeRuleAction {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="metricName")
    private final String metricName;
    @JsonProperty(value="resourceGroup")
    private final String resourceGroup;
    @JsonProperty(value="dimensions")
    private final List<String> dimensions;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public IngestTimeRuleMetricExtractionAction(String compartmentId, String namespace, String metricName, String resourceGroup, List<String> dimensions) {
        this.compartmentId = compartmentId;
        this.namespace = namespace;
        this.metricName = metricName;
        this.resourceGroup = resourceGroup;
        this.dimensions = dimensions;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IngestTimeRuleMetricExtractionAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", metricName=").append(String.valueOf(this.metricName));
        sb.append(", resourceGroup=").append(String.valueOf(this.resourceGroup));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IngestTimeRuleMetricExtractionAction)) {
            return false;
        }
        IngestTimeRuleMetricExtractionAction other = (IngestTimeRuleMetricExtractionAction)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.metricName, other.metricName) && Objects.equals(this.resourceGroup, other.resourceGroup) && Objects.equals(this.dimensions, other.dimensions) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.metricName == null ? 43 : this.metricName.hashCode());
        result = result * 59 + (this.resourceGroup == null ? 43 : this.resourceGroup.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="metricName")
        private String metricName;
        @JsonProperty(value="resourceGroup")
        private String resourceGroup;
        @JsonProperty(value="dimensions")
        private List<String> dimensions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder metricName(String metricName) {
            this.metricName = metricName;
            this.__explicitlySet__.add("metricName");
            return this;
        }

        public Builder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            this.__explicitlySet__.add("resourceGroup");
            return this;
        }

        public Builder dimensions(List<String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public IngestTimeRuleMetricExtractionAction build() {
            IngestTimeRuleMetricExtractionAction model = new IngestTimeRuleMetricExtractionAction(this.compartmentId, this.namespace, this.metricName, this.resourceGroup, this.dimensions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IngestTimeRuleMetricExtractionAction model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("metricName")) {
                this.metricName(model.getMetricName());
            }
            if (model.wasPropertyExplicitlySet("resourceGroup")) {
                this.resourceGroup(model.getResourceGroup());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            return this;
        }
    }
}

