/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.AssociationProperty;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsAssociationParameter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="agentId")
    private final String agentId;
    @JsonProperty(value="entityType")
    private final String entityType;
    @JsonProperty(value="entityId")
    private final String entityId;
    @JsonProperty(value="sourceId")
    private final String sourceId;
    @JsonProperty(value="sourceDisplayName")
    private final String sourceDisplayName;
    @JsonProperty(value="sourceType")
    private final String sourceType;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusDescription")
    private final String statusDescription;
    @JsonProperty(value="associationProperties")
    private final List<AssociationProperty> associationProperties;
    @JsonProperty(value="missingProperties")
    private final List<String> missingProperties;
    @JsonProperty(value="requiredProperties")
    private final List<String> requiredProperties;

    @Deprecated
    @ConstructorProperties(value={"agentId", "entityType", "entityId", "sourceId", "sourceDisplayName", "sourceType", "status", "statusDescription", "associationProperties", "missingProperties", "requiredProperties"})
    public LogAnalyticsAssociationParameter(String agentId, String entityType, String entityId, String sourceId, String sourceDisplayName, String sourceType, Status status, String statusDescription, List<AssociationProperty> associationProperties, List<String> missingProperties, List<String> requiredProperties) {
        this.agentId = agentId;
        this.entityType = entityType;
        this.entityId = entityId;
        this.sourceId = sourceId;
        this.sourceDisplayName = sourceDisplayName;
        this.sourceType = sourceType;
        this.status = status;
        this.statusDescription = statusDescription;
        this.associationProperties = associationProperties;
        this.missingProperties = missingProperties;
        this.requiredProperties = requiredProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public List<AssociationProperty> getAssociationProperties() {
        return this.associationProperties;
    }

    public List<String> getMissingProperties() {
        return this.missingProperties;
    }

    public List<String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsAssociationParameter(");
        sb.append("super=").append(super.toString());
        sb.append("agentId=").append(String.valueOf(this.agentId));
        sb.append(", entityType=").append(String.valueOf(this.entityType));
        sb.append(", entityId=").append(String.valueOf(this.entityId));
        sb.append(", sourceId=").append(String.valueOf(this.sourceId));
        sb.append(", sourceDisplayName=").append(String.valueOf(this.sourceDisplayName));
        sb.append(", sourceType=").append(String.valueOf(this.sourceType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusDescription=").append(String.valueOf(this.statusDescription));
        sb.append(", associationProperties=").append(String.valueOf(this.associationProperties));
        sb.append(", missingProperties=").append(String.valueOf(this.missingProperties));
        sb.append(", requiredProperties=").append(String.valueOf(this.requiredProperties));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsAssociationParameter)) {
            return false;
        }
        LogAnalyticsAssociationParameter other = (LogAnalyticsAssociationParameter)((Object)o);
        return Objects.equals(this.agentId, other.agentId) && Objects.equals(this.entityType, other.entityType) && Objects.equals(this.entityId, other.entityId) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.sourceDisplayName, other.sourceDisplayName) && Objects.equals(this.sourceType, other.sourceType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.statusDescription, other.statusDescription) && Objects.equals(this.associationProperties, other.associationProperties) && Objects.equals(this.missingProperties, other.missingProperties) && Objects.equals(this.requiredProperties, other.requiredProperties) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.entityType == null ? 43 : this.entityType.hashCode());
        result = result * 59 + (this.entityId == null ? 43 : this.entityId.hashCode());
        result = result * 59 + (this.sourceId == null ? 43 : this.sourceId.hashCode());
        result = result * 59 + (this.sourceDisplayName == null ? 43 : this.sourceDisplayName.hashCode());
        result = result * 59 + (this.sourceType == null ? 43 : this.sourceType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusDescription == null ? 43 : this.statusDescription.hashCode());
        result = result * 59 + (this.associationProperties == null ? 43 : this.associationProperties.hashCode());
        result = result * 59 + (this.missingProperties == null ? 43 : this.missingProperties.hashCode());
        result = result * 59 + (this.requiredProperties == null ? 43 : this.requiredProperties.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="agentId")
        private String agentId;
        @JsonProperty(value="entityType")
        private String entityType;
        @JsonProperty(value="entityId")
        private String entityId;
        @JsonProperty(value="sourceId")
        private String sourceId;
        @JsonProperty(value="sourceDisplayName")
        private String sourceDisplayName;
        @JsonProperty(value="sourceType")
        private String sourceType;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusDescription")
        private String statusDescription;
        @JsonProperty(value="associationProperties")
        private List<AssociationProperty> associationProperties;
        @JsonProperty(value="missingProperties")
        private List<String> missingProperties;
        @JsonProperty(value="requiredProperties")
        private List<String> requiredProperties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            this.__explicitlySet__.add("agentId");
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            this.__explicitlySet__.add("entityType");
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.__explicitlySet__.add("entityId");
            return this;
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.__explicitlySet__.add("sourceId");
            return this;
        }

        public Builder sourceDisplayName(String sourceDisplayName) {
            this.sourceDisplayName = sourceDisplayName;
            this.__explicitlySet__.add("sourceDisplayName");
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            this.__explicitlySet__.add("sourceType");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            this.__explicitlySet__.add("statusDescription");
            return this;
        }

        public Builder associationProperties(List<AssociationProperty> associationProperties) {
            this.associationProperties = associationProperties;
            this.__explicitlySet__.add("associationProperties");
            return this;
        }

        public Builder missingProperties(List<String> missingProperties) {
            this.missingProperties = missingProperties;
            this.__explicitlySet__.add("missingProperties");
            return this;
        }

        public Builder requiredProperties(List<String> requiredProperties) {
            this.requiredProperties = requiredProperties;
            this.__explicitlySet__.add("requiredProperties");
            return this;
        }

        public LogAnalyticsAssociationParameter build() {
            LogAnalyticsAssociationParameter model = new LogAnalyticsAssociationParameter(this.agentId, this.entityType, this.entityId, this.sourceId, this.sourceDisplayName, this.sourceType, this.status, this.statusDescription, this.associationProperties, this.missingProperties, this.requiredProperties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsAssociationParameter model) {
            if (model.wasPropertyExplicitlySet("agentId")) {
                this.agentId(model.getAgentId());
            }
            if (model.wasPropertyExplicitlySet("entityType")) {
                this.entityType(model.getEntityType());
            }
            if (model.wasPropertyExplicitlySet("entityId")) {
                this.entityId(model.getEntityId());
            }
            if (model.wasPropertyExplicitlySet("sourceId")) {
                this.sourceId(model.getSourceId());
            }
            if (model.wasPropertyExplicitlySet("sourceDisplayName")) {
                this.sourceDisplayName(model.getSourceDisplayName());
            }
            if (model.wasPropertyExplicitlySet("sourceType")) {
                this.sourceType(model.getSourceType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusDescription")) {
                this.statusDescription(model.getStatusDescription());
            }
            if (model.wasPropertyExplicitlySet("associationProperties")) {
                this.associationProperties(model.getAssociationProperties());
            }
            if (model.wasPropertyExplicitlySet("missingProperties")) {
                this.missingProperties(model.getMissingProperties());
            }
            if (model.wasPropertyExplicitlySet("requiredProperties")) {
                this.requiredProperties(model.getRequiredProperties());
            }
            return this;
        }
    }
}

