/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.LogAnalyticsField;
import com.oracle.bmc.loganalytics.model.LogAnalyticsSourceExtendedFieldDefinition;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LogAnalyticsExtendedField
extends ExplicitlySetBmcModel {
    @JsonProperty(value="field")
    private final LogAnalyticsField field;
    @JsonProperty(value="extendedFieldDefinition")
    private final LogAnalyticsSourceExtendedFieldDefinition extendedFieldDefinition;
    @JsonProperty(value="extendedFieldDefinitionId")
    private final Long extendedFieldDefinitionId;
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="fieldDisplayName")
    private final String fieldDisplayName;
    @JsonProperty(value="savedRegularExpressionName")
    private final String savedRegularExpressionName;
    @JsonProperty(value="extendedFieldId")
    private final Long extendedFieldId;

    @Deprecated
    @ConstructorProperties(value={"field", "extendedFieldDefinition", "extendedFieldDefinitionId", "fieldName", "fieldDisplayName", "savedRegularExpressionName", "extendedFieldId"})
    public LogAnalyticsExtendedField(LogAnalyticsField field, LogAnalyticsSourceExtendedFieldDefinition extendedFieldDefinition, Long extendedFieldDefinitionId, String fieldName, String fieldDisplayName, String savedRegularExpressionName, Long extendedFieldId) {
        this.field = field;
        this.extendedFieldDefinition = extendedFieldDefinition;
        this.extendedFieldDefinitionId = extendedFieldDefinitionId;
        this.fieldName = fieldName;
        this.fieldDisplayName = fieldDisplayName;
        this.savedRegularExpressionName = savedRegularExpressionName;
        this.extendedFieldId = extendedFieldId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public LogAnalyticsField getField() {
        return this.field;
    }

    public LogAnalyticsSourceExtendedFieldDefinition getExtendedFieldDefinition() {
        return this.extendedFieldDefinition;
    }

    public Long getExtendedFieldDefinitionId() {
        return this.extendedFieldDefinitionId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public String getSavedRegularExpressionName() {
        return this.savedRegularExpressionName;
    }

    public Long getExtendedFieldId() {
        return this.extendedFieldId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LogAnalyticsExtendedField(");
        sb.append("super=").append(super.toString());
        sb.append("field=").append(String.valueOf((Object)this.field));
        sb.append(", extendedFieldDefinition=").append(String.valueOf((Object)this.extendedFieldDefinition));
        sb.append(", extendedFieldDefinitionId=").append(String.valueOf(this.extendedFieldDefinitionId));
        sb.append(", fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", fieldDisplayName=").append(String.valueOf(this.fieldDisplayName));
        sb.append(", savedRegularExpressionName=").append(String.valueOf(this.savedRegularExpressionName));
        sb.append(", extendedFieldId=").append(String.valueOf(this.extendedFieldId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogAnalyticsExtendedField)) {
            return false;
        }
        LogAnalyticsExtendedField other = (LogAnalyticsExtendedField)((Object)o);
        return Objects.equals((Object)this.field, (Object)other.field) && Objects.equals((Object)this.extendedFieldDefinition, (Object)other.extendedFieldDefinition) && Objects.equals(this.extendedFieldDefinitionId, other.extendedFieldDefinitionId) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.fieldDisplayName, other.fieldDisplayName) && Objects.equals(this.savedRegularExpressionName, other.savedRegularExpressionName) && Objects.equals(this.extendedFieldId, other.extendedFieldId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.field == null ? 43 : this.field.hashCode());
        result = result * 59 + (this.extendedFieldDefinition == null ? 43 : this.extendedFieldDefinition.hashCode());
        result = result * 59 + (this.extendedFieldDefinitionId == null ? 43 : this.extendedFieldDefinitionId.hashCode());
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.fieldDisplayName == null ? 43 : this.fieldDisplayName.hashCode());
        result = result * 59 + (this.savedRegularExpressionName == null ? 43 : this.savedRegularExpressionName.hashCode());
        result = result * 59 + (this.extendedFieldId == null ? 43 : this.extendedFieldId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="field")
        private LogAnalyticsField field;
        @JsonProperty(value="extendedFieldDefinition")
        private LogAnalyticsSourceExtendedFieldDefinition extendedFieldDefinition;
        @JsonProperty(value="extendedFieldDefinitionId")
        private Long extendedFieldDefinitionId;
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="fieldDisplayName")
        private String fieldDisplayName;
        @JsonProperty(value="savedRegularExpressionName")
        private String savedRegularExpressionName;
        @JsonProperty(value="extendedFieldId")
        private Long extendedFieldId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder field(LogAnalyticsField field) {
            this.field = field;
            this.__explicitlySet__.add("field");
            return this;
        }

        public Builder extendedFieldDefinition(LogAnalyticsSourceExtendedFieldDefinition extendedFieldDefinition) {
            this.extendedFieldDefinition = extendedFieldDefinition;
            this.__explicitlySet__.add("extendedFieldDefinition");
            return this;
        }

        public Builder extendedFieldDefinitionId(Long extendedFieldDefinitionId) {
            this.extendedFieldDefinitionId = extendedFieldDefinitionId;
            this.__explicitlySet__.add("extendedFieldDefinitionId");
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder fieldDisplayName(String fieldDisplayName) {
            this.fieldDisplayName = fieldDisplayName;
            this.__explicitlySet__.add("fieldDisplayName");
            return this;
        }

        public Builder savedRegularExpressionName(String savedRegularExpressionName) {
            this.savedRegularExpressionName = savedRegularExpressionName;
            this.__explicitlySet__.add("savedRegularExpressionName");
            return this;
        }

        public Builder extendedFieldId(Long extendedFieldId) {
            this.extendedFieldId = extendedFieldId;
            this.__explicitlySet__.add("extendedFieldId");
            return this;
        }

        public LogAnalyticsExtendedField build() {
            LogAnalyticsExtendedField model = new LogAnalyticsExtendedField(this.field, this.extendedFieldDefinition, this.extendedFieldDefinitionId, this.fieldName, this.fieldDisplayName, this.savedRegularExpressionName, this.extendedFieldId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LogAnalyticsExtendedField model) {
            if (model.wasPropertyExplicitlySet("field")) {
                this.field(model.getField());
            }
            if (model.wasPropertyExplicitlySet("extendedFieldDefinition")) {
                this.extendedFieldDefinition(model.getExtendedFieldDefinition());
            }
            if (model.wasPropertyExplicitlySet("extendedFieldDefinitionId")) {
                this.extendedFieldDefinitionId(model.getExtendedFieldDefinitionId());
            }
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("fieldDisplayName")) {
                this.fieldDisplayName(model.getFieldDisplayName());
            }
            if (model.wasPropertyExplicitlySet("savedRegularExpressionName")) {
                this.savedRegularExpressionName(model.getSavedRegularExpressionName());
            }
            if (model.wasPropertyExplicitlySet("extendedFieldId")) {
                this.extendedFieldId(model.getExtendedFieldId());
            }
            return this;
        }
    }
}

