/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.AbstractColumn;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class QueryAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalCount")
    private final Integer totalCount;
    @JsonProperty(value="totalMatchedCount")
    private final Long totalMatchedCount;
    @JsonProperty(value="arePartialResults")
    private final Boolean arePartialResults;
    @JsonProperty(value="partialResultReason")
    private final String partialResultReason;
    @JsonProperty(value="isContentHidden")
    private final Boolean isContentHidden;
    @JsonProperty(value="columns")
    private final List<AbstractColumn> columns;
    @JsonProperty(value="fields")
    private final List<AbstractColumn> fields;
    @JsonProperty(value="items")
    private final List<Map<String, Object>> items;
    @JsonProperty(value="queryExecutionTimeInMs")
    private final Long queryExecutionTimeInMs;
    @JsonProperty(value="percentComplete")
    private final Integer percentComplete;

    @Deprecated
    @ConstructorProperties(value={"totalCount", "totalMatchedCount", "arePartialResults", "partialResultReason", "isContentHidden", "columns", "fields", "items", "queryExecutionTimeInMs", "percentComplete"})
    public QueryAggregation(Integer totalCount, Long totalMatchedCount, Boolean arePartialResults, String partialResultReason, Boolean isContentHidden, List<AbstractColumn> columns, List<AbstractColumn> fields, List<Map<String, Object>> items, Long queryExecutionTimeInMs, Integer percentComplete) {
        this.totalCount = totalCount;
        this.totalMatchedCount = totalMatchedCount;
        this.arePartialResults = arePartialResults;
        this.partialResultReason = partialResultReason;
        this.isContentHidden = isContentHidden;
        this.columns = columns;
        this.fields = fields;
        this.items = items;
        this.queryExecutionTimeInMs = queryExecutionTimeInMs;
        this.percentComplete = percentComplete;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public Long getTotalMatchedCount() {
        return this.totalMatchedCount;
    }

    public Boolean getArePartialResults() {
        return this.arePartialResults;
    }

    public String getPartialResultReason() {
        return this.partialResultReason;
    }

    public Boolean getIsContentHidden() {
        return this.isContentHidden;
    }

    public List<AbstractColumn> getColumns() {
        return this.columns;
    }

    public List<AbstractColumn> getFields() {
        return this.fields;
    }

    public List<Map<String, Object>> getItems() {
        return this.items;
    }

    public Long getQueryExecutionTimeInMs() {
        return this.queryExecutionTimeInMs;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("QueryAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("totalCount=").append(String.valueOf(this.totalCount));
        sb.append(", totalMatchedCount=").append(String.valueOf(this.totalMatchedCount));
        sb.append(", arePartialResults=").append(String.valueOf(this.arePartialResults));
        sb.append(", partialResultReason=").append(String.valueOf(this.partialResultReason));
        sb.append(", isContentHidden=").append(String.valueOf(this.isContentHidden));
        sb.append(", columns=").append(String.valueOf(this.columns));
        sb.append(", fields=").append(String.valueOf(this.fields));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(", queryExecutionTimeInMs=").append(String.valueOf(this.queryExecutionTimeInMs));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryAggregation)) {
            return false;
        }
        QueryAggregation other = (QueryAggregation)((Object)o);
        return Objects.equals(this.totalCount, other.totalCount) && Objects.equals(this.totalMatchedCount, other.totalMatchedCount) && Objects.equals(this.arePartialResults, other.arePartialResults) && Objects.equals(this.partialResultReason, other.partialResultReason) && Objects.equals(this.isContentHidden, other.isContentHidden) && Objects.equals(this.columns, other.columns) && Objects.equals(this.fields, other.fields) && Objects.equals(this.items, other.items) && Objects.equals(this.queryExecutionTimeInMs, other.queryExecutionTimeInMs) && Objects.equals(this.percentComplete, other.percentComplete) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalCount == null ? 43 : this.totalCount.hashCode());
        result = result * 59 + (this.totalMatchedCount == null ? 43 : this.totalMatchedCount.hashCode());
        result = result * 59 + (this.arePartialResults == null ? 43 : this.arePartialResults.hashCode());
        result = result * 59 + (this.partialResultReason == null ? 43 : this.partialResultReason.hashCode());
        result = result * 59 + (this.isContentHidden == null ? 43 : this.isContentHidden.hashCode());
        result = result * 59 + (this.columns == null ? 43 : this.columns.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + (this.queryExecutionTimeInMs == null ? 43 : this.queryExecutionTimeInMs.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="totalMatchedCount")
        private Long totalMatchedCount;
        @JsonProperty(value="arePartialResults")
        private Boolean arePartialResults;
        @JsonProperty(value="partialResultReason")
        private String partialResultReason;
        @JsonProperty(value="isContentHidden")
        private Boolean isContentHidden;
        @JsonProperty(value="columns")
        private List<AbstractColumn> columns;
        @JsonProperty(value="fields")
        private List<AbstractColumn> fields;
        @JsonProperty(value="items")
        private List<Map<String, Object>> items;
        @JsonProperty(value="queryExecutionTimeInMs")
        private Long queryExecutionTimeInMs;
        @JsonProperty(value="percentComplete")
        private Integer percentComplete;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            this.__explicitlySet__.add("totalCount");
            return this;
        }

        public Builder totalMatchedCount(Long totalMatchedCount) {
            this.totalMatchedCount = totalMatchedCount;
            this.__explicitlySet__.add("totalMatchedCount");
            return this;
        }

        public Builder arePartialResults(Boolean arePartialResults) {
            this.arePartialResults = arePartialResults;
            this.__explicitlySet__.add("arePartialResults");
            return this;
        }

        public Builder partialResultReason(String partialResultReason) {
            this.partialResultReason = partialResultReason;
            this.__explicitlySet__.add("partialResultReason");
            return this;
        }

        public Builder isContentHidden(Boolean isContentHidden) {
            this.isContentHidden = isContentHidden;
            this.__explicitlySet__.add("isContentHidden");
            return this;
        }

        public Builder columns(List<AbstractColumn> columns) {
            this.columns = columns;
            this.__explicitlySet__.add("columns");
            return this;
        }

        public Builder fields(List<AbstractColumn> fields) {
            this.fields = fields;
            this.__explicitlySet__.add("fields");
            return this;
        }

        public Builder items(List<Map<String, Object>> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public Builder queryExecutionTimeInMs(Long queryExecutionTimeInMs) {
            this.queryExecutionTimeInMs = queryExecutionTimeInMs;
            this.__explicitlySet__.add("queryExecutionTimeInMs");
            return this;
        }

        public Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public QueryAggregation build() {
            QueryAggregation model = new QueryAggregation(this.totalCount, this.totalMatchedCount, this.arePartialResults, this.partialResultReason, this.isContentHidden, this.columns, this.fields, this.items, this.queryExecutionTimeInMs, this.percentComplete);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(QueryAggregation model) {
            if (model.wasPropertyExplicitlySet("totalCount")) {
                this.totalCount(model.getTotalCount());
            }
            if (model.wasPropertyExplicitlySet("totalMatchedCount")) {
                this.totalMatchedCount(model.getTotalMatchedCount());
            }
            if (model.wasPropertyExplicitlySet("arePartialResults")) {
                this.arePartialResults(model.getArePartialResults());
            }
            if (model.wasPropertyExplicitlySet("partialResultReason")) {
                this.partialResultReason(model.getPartialResultReason());
            }
            if (model.wasPropertyExplicitlySet("isContentHidden")) {
                this.isContentHidden(model.getIsContentHidden());
            }
            if (model.wasPropertyExplicitlySet("columns")) {
                this.columns(model.getColumns());
            }
            if (model.wasPropertyExplicitlySet("fields")) {
                this.fields(model.getFields());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            if (model.wasPropertyExplicitlySet("queryExecutionTimeInMs")) {
                this.queryExecutionTimeInMs(model.getQueryExecutionTimeInMs());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            return this;
        }
    }
}

