/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.loganalytics.model.AbstractColumn;
import com.oracle.bmc.loganalytics.model.FieldValue;
import com.oracle.bmc.loganalytics.model.SubSystemName;
import com.oracle.bmc.loganalytics.model.ValueType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class TimeClusterDataColumn
extends AbstractColumn {
    @JsonProperty(value="columns")
    private final List<AbstractColumn> columns;
    @JsonProperty(value="result")
    private final List<Map<String, Object>> result;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TimeClusterDataColumn(String displayName, SubSystemName subSystem, List<FieldValue> values, Boolean isListOfValues, Boolean isMultiValued, Boolean isCaseSensitive, Boolean isGroupable, Boolean isEvaluable, Boolean isHidden, ValueType valueType, String originalDisplayName, String internalName, List<AbstractColumn> columns, List<Map<String, Object>> result) {
        super(displayName, subSystem, values, isListOfValues, isMultiValued, isCaseSensitive, isGroupable, isEvaluable, isHidden, valueType, originalDisplayName, internalName);
        this.columns = columns;
        this.result = result;
    }

    public List<AbstractColumn> getColumns() {
        return this.columns;
    }

    public List<Map<String, Object>> getResult() {
        return this.result;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeClusterDataColumn(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", columns=").append(String.valueOf(this.columns));
        sb.append(", result=").append(String.valueOf(this.result));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeClusterDataColumn)) {
            return false;
        }
        TimeClusterDataColumn other = (TimeClusterDataColumn)((Object)o);
        return Objects.equals(this.columns, other.columns) && Objects.equals(this.result, other.result) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.columns == null ? 43 : this.columns.hashCode());
        result = result * 59 + (this.result == null ? 43 : this.result.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="subSystem")
        private SubSystemName subSystem;
        @JsonProperty(value="values")
        private List<FieldValue> values;
        @JsonProperty(value="isListOfValues")
        private Boolean isListOfValues;
        @JsonProperty(value="isMultiValued")
        private Boolean isMultiValued;
        @JsonProperty(value="isCaseSensitive")
        private Boolean isCaseSensitive;
        @JsonProperty(value="isGroupable")
        private Boolean isGroupable;
        @JsonProperty(value="isEvaluable")
        private Boolean isEvaluable;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonProperty(value="valueType")
        private ValueType valueType;
        @JsonProperty(value="originalDisplayName")
        private String originalDisplayName;
        @JsonProperty(value="internalName")
        private String internalName;
        @JsonProperty(value="columns")
        private List<AbstractColumn> columns;
        @JsonProperty(value="result")
        private List<Map<String, Object>> result;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder subSystem(SubSystemName subSystem) {
            this.subSystem = subSystem;
            this.__explicitlySet__.add("subSystem");
            return this;
        }

        public Builder values(List<FieldValue> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public Builder isListOfValues(Boolean isListOfValues) {
            this.isListOfValues = isListOfValues;
            this.__explicitlySet__.add("isListOfValues");
            return this;
        }

        public Builder isMultiValued(Boolean isMultiValued) {
            this.isMultiValued = isMultiValued;
            this.__explicitlySet__.add("isMultiValued");
            return this;
        }

        public Builder isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            this.__explicitlySet__.add("isCaseSensitive");
            return this;
        }

        public Builder isGroupable(Boolean isGroupable) {
            this.isGroupable = isGroupable;
            this.__explicitlySet__.add("isGroupable");
            return this;
        }

        public Builder isEvaluable(Boolean isEvaluable) {
            this.isEvaluable = isEvaluable;
            this.__explicitlySet__.add("isEvaluable");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public Builder valueType(ValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public Builder originalDisplayName(String originalDisplayName) {
            this.originalDisplayName = originalDisplayName;
            this.__explicitlySet__.add("originalDisplayName");
            return this;
        }

        public Builder internalName(String internalName) {
            this.internalName = internalName;
            this.__explicitlySet__.add("internalName");
            return this;
        }

        public Builder columns(List<AbstractColumn> columns) {
            this.columns = columns;
            this.__explicitlySet__.add("columns");
            return this;
        }

        public Builder result(List<Map<String, Object>> result) {
            this.result = result;
            this.__explicitlySet__.add("result");
            return this;
        }

        public TimeClusterDataColumn build() {
            TimeClusterDataColumn model = new TimeClusterDataColumn(this.displayName, this.subSystem, this.values, this.isListOfValues, this.isMultiValued, this.isCaseSensitive, this.isGroupable, this.isEvaluable, this.isHidden, this.valueType, this.originalDisplayName, this.internalName, this.columns, this.result);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TimeClusterDataColumn model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("subSystem")) {
                this.subSystem(model.getSubSystem());
            }
            if (model.wasPropertyExplicitlySet("values")) {
                this.values(model.getValues());
            }
            if (model.wasPropertyExplicitlySet("isListOfValues")) {
                this.isListOfValues(model.getIsListOfValues());
            }
            if (model.wasPropertyExplicitlySet("isMultiValued")) {
                this.isMultiValued(model.getIsMultiValued());
            }
            if (model.wasPropertyExplicitlySet("isCaseSensitive")) {
                this.isCaseSensitive(model.getIsCaseSensitive());
            }
            if (model.wasPropertyExplicitlySet("isGroupable")) {
                this.isGroupable(model.getIsGroupable());
            }
            if (model.wasPropertyExplicitlySet("isEvaluable")) {
                this.isEvaluable(model.getIsEvaluable());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            if (model.wasPropertyExplicitlySet("originalDisplayName")) {
                this.originalDisplayName(model.getOriginalDisplayName());
            }
            if (model.wasPropertyExplicitlySet("internalName")) {
                this.internalName(model.getInternalName());
            }
            if (model.wasPropertyExplicitlySet("columns")) {
                this.columns(model.getColumns());
            }
            if (model.wasPropertyExplicitlySet("result")) {
                this.result(model.getResult());
            }
            return this;
        }
    }
}

