/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RegisterLookupRequest
extends BmcRequest<InputStream> {
    private String namespaceName;
    private Type type;
    private InputStream registerLookupContentFileBody;
    private String name;
    private String description;
    private String charEncoding;
    private Boolean isHidden;
    private String opcRetryToken;
    private String opcRequestId;
    private String expect;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public Type getType() {
        return this.type;
    }

    public InputStream getRegisterLookupContentFileBody() {
        return this.registerLookupContentFileBody;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getExpect() {
        return this.expect;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.registerLookupContentFileBody;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).type(this.type).registerLookupContentFileBody(this.registerLookupContentFileBody).name(this.name).description(this.description).charEncoding(this.charEncoding).isHidden(this.isHidden).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).expect(this.expect);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(",registerLookupContentFileBody=").append(String.valueOf(this.registerLookupContentFileBody));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",description=").append(String.valueOf(this.description));
        sb.append(",charEncoding=").append(String.valueOf(this.charEncoding));
        sb.append(",isHidden=").append(String.valueOf(this.isHidden));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",expect=").append(String.valueOf(this.expect));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisterLookupRequest)) {
            return false;
        }
        RegisterLookupRequest other = (RegisterLookupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.registerLookupContentFileBody, other.registerLookupContentFileBody) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.charEncoding, other.charEncoding) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.expect, other.expect);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.registerLookupContentFileBody == null ? 43 : this.registerLookupContentFileBody.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.charEncoding == null ? 43 : this.charEncoding.hashCode());
        result = result * 59 + (this.isHidden == null ? 43 : this.isHidden.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.expect == null ? 43 : this.expect.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RegisterLookupRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private Type type = null;
        private InputStream registerLookupContentFileBody = null;
        private String name = null;
        private String description = null;
        private String charEncoding = null;
        private Boolean isHidden = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String expect = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder registerLookupContentFileBody(InputStream registerLookupContentFileBody) {
            this.registerLookupContentFileBody = registerLookupContentFileBody;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder charEncoding(String charEncoding) {
            this.charEncoding = charEncoding;
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder expect(String expect) {
            this.expect = expect;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RegisterLookupRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.type(o.getType());
            this.registerLookupContentFileBody(o.getRegisterLookupContentFileBody());
            this.name(o.getName());
            this.description(o.getDescription());
            this.charEncoding(o.getCharEncoding());
            this.isHidden(o.getIsHidden());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.expect(o.getExpect());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RegisterLookupRequest build() {
            RegisterLookupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.registerLookupContentFileBody(body);
            return this;
        }

        public RegisterLookupRequest buildWithoutInvocationCallback() {
            RegisterLookupRequest request = new RegisterLookupRequest();
            request.namespaceName = this.namespaceName;
            request.type = this.type;
            request.registerLookupContentFileBody = this.registerLookupContentFileBody;
            request.name = this.name;
            request.description = this.description;
            request.charEncoding = this.charEncoding;
            request.isHidden = this.isHidden;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.expect = this.expect;
            return request;
        }
    }

    public static enum Type implements BmcEnum
    {
        Lookup("Lookup"),
        Dictionary("Dictionary"),
        Module("Module");

        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Type: " + key);
        }

        static {
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

