/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.responses;

import com.oracle.bmc.loganalytics.model.FilterOutput;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FilterResponse
extends BmcResponse {
    private String opcRequestId;
    private FilterOutput filterOutput;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public FilterOutput getFilterOutput() {
        return this.filterOutput;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "filterOutput"})
    private FilterResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, FilterOutput filterOutput) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.filterOutput = filterOutput;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",filterOutput=").append(String.valueOf((Object)this.filterOutput));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterResponse)) {
            return false;
        }
        FilterResponse other = (FilterResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.filterOutput, (Object)other.filterOutput);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.filterOutput == null ? 43 : this.filterOutput.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<FilterResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private FilterOutput filterOutput;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder filterOutput(FilterOutput filterOutput) {
            this.filterOutput = filterOutput;
            return this;
        }

        public Builder copy(FilterResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.filterOutput(o.getFilterOutput());
            return this;
        }

        public FilterResponse build() {
            return new FilterResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.filterOutput);
        }
    }
}

