/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConditionBlock
extends ExplicitlySetBmcModel {
    @JsonProperty(value="conditionBlocksOperator")
    private final ConditionBlocksOperator conditionBlocksOperator;
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="labelConditionOperator")
    private final String labelConditionOperator;
    @JsonProperty(value="labelConditionValue")
    private final String labelConditionValue;
    @JsonProperty(value="labelConditionValues")
    private final List<String> labelConditionValues;
    @JsonProperty(value="conditionBlocks")
    private final List<ConditionBlock> conditionBlocks;

    @Deprecated
    @ConstructorProperties(value={"conditionBlocksOperator", "fieldName", "labelConditionOperator", "labelConditionValue", "labelConditionValues", "conditionBlocks"})
    public ConditionBlock(ConditionBlocksOperator conditionBlocksOperator, String fieldName, String labelConditionOperator, String labelConditionValue, List<String> labelConditionValues, List<ConditionBlock> conditionBlocks) {
        this.conditionBlocksOperator = conditionBlocksOperator;
        this.fieldName = fieldName;
        this.labelConditionOperator = labelConditionOperator;
        this.labelConditionValue = labelConditionValue;
        this.labelConditionValues = labelConditionValues;
        this.conditionBlocks = conditionBlocks;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ConditionBlocksOperator getConditionBlocksOperator() {
        return this.conditionBlocksOperator;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getLabelConditionOperator() {
        return this.labelConditionOperator;
    }

    public String getLabelConditionValue() {
        return this.labelConditionValue;
    }

    public List<String> getLabelConditionValues() {
        return this.labelConditionValues;
    }

    public List<ConditionBlock> getConditionBlocks() {
        return this.conditionBlocks;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConditionBlock(");
        sb.append("super=").append(super.toString());
        sb.append("conditionBlocksOperator=").append(String.valueOf((Object)this.conditionBlocksOperator));
        sb.append(", fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", labelConditionOperator=").append(String.valueOf(this.labelConditionOperator));
        sb.append(", labelConditionValue=").append(String.valueOf(this.labelConditionValue));
        sb.append(", labelConditionValues=").append(String.valueOf(this.labelConditionValues));
        sb.append(", conditionBlocks=").append(String.valueOf(this.conditionBlocks));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConditionBlock)) {
            return false;
        }
        ConditionBlock other = (ConditionBlock)((Object)o);
        return Objects.equals((Object)this.conditionBlocksOperator, (Object)other.conditionBlocksOperator) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.labelConditionOperator, other.labelConditionOperator) && Objects.equals(this.labelConditionValue, other.labelConditionValue) && Objects.equals(this.labelConditionValues, other.labelConditionValues) && Objects.equals(this.conditionBlocks, other.conditionBlocks) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.conditionBlocksOperator == null ? 43 : this.conditionBlocksOperator.hashCode());
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.labelConditionOperator == null ? 43 : this.labelConditionOperator.hashCode());
        result = result * 59 + (this.labelConditionValue == null ? 43 : this.labelConditionValue.hashCode());
        result = result * 59 + (this.labelConditionValues == null ? 43 : this.labelConditionValues.hashCode());
        result = result * 59 + (this.conditionBlocks == null ? 43 : this.conditionBlocks.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConditionBlocksOperator implements BmcEnum
    {
        And("AND"),
        Or("OR"),
        NotAnd("NOT_AND"),
        NotOr("NOT_OR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConditionBlocksOperator> map;

        private ConditionBlocksOperator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConditionBlocksOperator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConditionBlocksOperator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConditionBlocksOperator.class);
            map = new HashMap<String, ConditionBlocksOperator>();
            for (ConditionBlocksOperator v : ConditionBlocksOperator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="conditionBlocksOperator")
        private ConditionBlocksOperator conditionBlocksOperator;
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="labelConditionOperator")
        private String labelConditionOperator;
        @JsonProperty(value="labelConditionValue")
        private String labelConditionValue;
        @JsonProperty(value="labelConditionValues")
        private List<String> labelConditionValues;
        @JsonProperty(value="conditionBlocks")
        private List<ConditionBlock> conditionBlocks;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder conditionBlocksOperator(ConditionBlocksOperator conditionBlocksOperator) {
            this.conditionBlocksOperator = conditionBlocksOperator;
            this.__explicitlySet__.add("conditionBlocksOperator");
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder labelConditionOperator(String labelConditionOperator) {
            this.labelConditionOperator = labelConditionOperator;
            this.__explicitlySet__.add("labelConditionOperator");
            return this;
        }

        public Builder labelConditionValue(String labelConditionValue) {
            this.labelConditionValue = labelConditionValue;
            this.__explicitlySet__.add("labelConditionValue");
            return this;
        }

        public Builder labelConditionValues(List<String> labelConditionValues) {
            this.labelConditionValues = labelConditionValues;
            this.__explicitlySet__.add("labelConditionValues");
            return this;
        }

        public Builder conditionBlocks(List<ConditionBlock> conditionBlocks) {
            this.conditionBlocks = conditionBlocks;
            this.__explicitlySet__.add("conditionBlocks");
            return this;
        }

        public ConditionBlock build() {
            ConditionBlock model = new ConditionBlock(this.conditionBlocksOperator, this.fieldName, this.labelConditionOperator, this.labelConditionValue, this.labelConditionValues, this.conditionBlocks);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConditionBlock model) {
            if (model.wasPropertyExplicitlySet("conditionBlocksOperator")) {
                this.conditionBlocksOperator(model.getConditionBlocksOperator());
            }
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("labelConditionOperator")) {
                this.labelConditionOperator(model.getLabelConditionOperator());
            }
            if (model.wasPropertyExplicitlySet("labelConditionValue")) {
                this.labelConditionValue(model.getLabelConditionValue());
            }
            if (model.wasPropertyExplicitlySet("labelConditionValues")) {
                this.labelConditionValues(model.getLabelConditionValues());
            }
            if (model.wasPropertyExplicitlySet("conditionBlocks")) {
                this.conditionBlocks(model.getConditionBlocks());
            }
            return this;
        }
    }
}

