/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EstimateRecallDataSizeResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeDataEnded")
    private final Date timeDataEnded;
    @JsonProperty(value="timeDataStarted")
    private final Date timeDataStarted;
    @JsonProperty(value="sizeInBytes")
    private final Long sizeInBytes;
    @JsonProperty(value="isOverlappingWithExistingRecalls")
    private final Boolean isOverlappingWithExistingRecalls;
    @JsonProperty(value="coreGroupCount")
    private final Integer coreGroupCount;
    @JsonProperty(value="coreGroupCountLimit")
    private final Integer coreGroupCountLimit;
    @JsonProperty(value="sizeLimitInBytes")
    private final Long sizeLimitInBytes;

    @Deprecated
    @ConstructorProperties(value={"timeDataEnded", "timeDataStarted", "sizeInBytes", "isOverlappingWithExistingRecalls", "coreGroupCount", "coreGroupCountLimit", "sizeLimitInBytes"})
    public EstimateRecallDataSizeResult(Date timeDataEnded, Date timeDataStarted, Long sizeInBytes, Boolean isOverlappingWithExistingRecalls, Integer coreGroupCount, Integer coreGroupCountLimit, Long sizeLimitInBytes) {
        this.timeDataEnded = timeDataEnded;
        this.timeDataStarted = timeDataStarted;
        this.sizeInBytes = sizeInBytes;
        this.isOverlappingWithExistingRecalls = isOverlappingWithExistingRecalls;
        this.coreGroupCount = coreGroupCount;
        this.coreGroupCountLimit = coreGroupCountLimit;
        this.sizeLimitInBytes = sizeLimitInBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeDataEnded() {
        return this.timeDataEnded;
    }

    public Date getTimeDataStarted() {
        return this.timeDataStarted;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Boolean getIsOverlappingWithExistingRecalls() {
        return this.isOverlappingWithExistingRecalls;
    }

    public Integer getCoreGroupCount() {
        return this.coreGroupCount;
    }

    public Integer getCoreGroupCountLimit() {
        return this.coreGroupCountLimit;
    }

    public Long getSizeLimitInBytes() {
        return this.sizeLimitInBytes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EstimateRecallDataSizeResult(");
        sb.append("super=").append(super.toString());
        sb.append("timeDataEnded=").append(String.valueOf(this.timeDataEnded));
        sb.append(", timeDataStarted=").append(String.valueOf(this.timeDataStarted));
        sb.append(", sizeInBytes=").append(String.valueOf(this.sizeInBytes));
        sb.append(", isOverlappingWithExistingRecalls=").append(String.valueOf(this.isOverlappingWithExistingRecalls));
        sb.append(", coreGroupCount=").append(String.valueOf(this.coreGroupCount));
        sb.append(", coreGroupCountLimit=").append(String.valueOf(this.coreGroupCountLimit));
        sb.append(", sizeLimitInBytes=").append(String.valueOf(this.sizeLimitInBytes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EstimateRecallDataSizeResult)) {
            return false;
        }
        EstimateRecallDataSizeResult other = (EstimateRecallDataSizeResult)((Object)o);
        return Objects.equals(this.timeDataEnded, other.timeDataEnded) && Objects.equals(this.timeDataStarted, other.timeDataStarted) && Objects.equals(this.sizeInBytes, other.sizeInBytes) && Objects.equals(this.isOverlappingWithExistingRecalls, other.isOverlappingWithExistingRecalls) && Objects.equals(this.coreGroupCount, other.coreGroupCount) && Objects.equals(this.coreGroupCountLimit, other.coreGroupCountLimit) && Objects.equals(this.sizeLimitInBytes, other.sizeLimitInBytes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeDataEnded == null ? 43 : this.timeDataEnded.hashCode());
        result = result * 59 + (this.timeDataStarted == null ? 43 : this.timeDataStarted.hashCode());
        result = result * 59 + (this.sizeInBytes == null ? 43 : this.sizeInBytes.hashCode());
        result = result * 59 + (this.isOverlappingWithExistingRecalls == null ? 43 : this.isOverlappingWithExistingRecalls.hashCode());
        result = result * 59 + (this.coreGroupCount == null ? 43 : this.coreGroupCount.hashCode());
        result = result * 59 + (this.coreGroupCountLimit == null ? 43 : this.coreGroupCountLimit.hashCode());
        result = result * 59 + (this.sizeLimitInBytes == null ? 43 : this.sizeLimitInBytes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeDataEnded")
        private Date timeDataEnded;
        @JsonProperty(value="timeDataStarted")
        private Date timeDataStarted;
        @JsonProperty(value="sizeInBytes")
        private Long sizeInBytes;
        @JsonProperty(value="isOverlappingWithExistingRecalls")
        private Boolean isOverlappingWithExistingRecalls;
        @JsonProperty(value="coreGroupCount")
        private Integer coreGroupCount;
        @JsonProperty(value="coreGroupCountLimit")
        private Integer coreGroupCountLimit;
        @JsonProperty(value="sizeLimitInBytes")
        private Long sizeLimitInBytes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeDataEnded(Date timeDataEnded) {
            this.timeDataEnded = timeDataEnded;
            this.__explicitlySet__.add("timeDataEnded");
            return this;
        }

        public Builder timeDataStarted(Date timeDataStarted) {
            this.timeDataStarted = timeDataStarted;
            this.__explicitlySet__.add("timeDataStarted");
            return this;
        }

        public Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            this.__explicitlySet__.add("sizeInBytes");
            return this;
        }

        public Builder isOverlappingWithExistingRecalls(Boolean isOverlappingWithExistingRecalls) {
            this.isOverlappingWithExistingRecalls = isOverlappingWithExistingRecalls;
            this.__explicitlySet__.add("isOverlappingWithExistingRecalls");
            return this;
        }

        public Builder coreGroupCount(Integer coreGroupCount) {
            this.coreGroupCount = coreGroupCount;
            this.__explicitlySet__.add("coreGroupCount");
            return this;
        }

        public Builder coreGroupCountLimit(Integer coreGroupCountLimit) {
            this.coreGroupCountLimit = coreGroupCountLimit;
            this.__explicitlySet__.add("coreGroupCountLimit");
            return this;
        }

        public Builder sizeLimitInBytes(Long sizeLimitInBytes) {
            this.sizeLimitInBytes = sizeLimitInBytes;
            this.__explicitlySet__.add("sizeLimitInBytes");
            return this;
        }

        public EstimateRecallDataSizeResult build() {
            EstimateRecallDataSizeResult model = new EstimateRecallDataSizeResult(this.timeDataEnded, this.timeDataStarted, this.sizeInBytes, this.isOverlappingWithExistingRecalls, this.coreGroupCount, this.coreGroupCountLimit, this.sizeLimitInBytes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EstimateRecallDataSizeResult model) {
            if (model.wasPropertyExplicitlySet("timeDataEnded")) {
                this.timeDataEnded(model.getTimeDataEnded());
            }
            if (model.wasPropertyExplicitlySet("timeDataStarted")) {
                this.timeDataStarted(model.getTimeDataStarted());
            }
            if (model.wasPropertyExplicitlySet("sizeInBytes")) {
                this.sizeInBytes(model.getSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("isOverlappingWithExistingRecalls")) {
                this.isOverlappingWithExistingRecalls(model.getIsOverlappingWithExistingRecalls());
            }
            if (model.wasPropertyExplicitlySet("coreGroupCount")) {
                this.coreGroupCount(model.getCoreGroupCount());
            }
            if (model.wasPropertyExplicitlySet("coreGroupCountLimit")) {
                this.coreGroupCountLimit(model.getCoreGroupCountLimit());
            }
            if (model.wasPropertyExplicitlySet("sizeLimitInBytes")) {
                this.sizeLimitInBytes(model.getSizeLimitInBytes());
            }
            return this;
        }
    }
}

