/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.loganalytics.model.AbstractColumn;
import com.oracle.bmc.loganalytics.model.AbstractCommandDescriptor;
import com.oracle.bmc.loganalytics.model.TimeRange;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ParseQueryOutput
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayQueryString")
    private final String displayQueryString;
    @JsonProperty(value="internalQueryString")
    private final String internalQueryString;
    @JsonProperty(value="columns")
    private final List<AbstractColumn> columns;
    @JsonProperty(value="responseTimeInMs")
    private final Long responseTimeInMs;
    @JsonProperty(value="timeFilter")
    private final TimeRange timeFilter;
    @JsonProperty(value="commands")
    private final List<AbstractCommandDescriptor> commands;

    @Deprecated
    @ConstructorProperties(value={"displayQueryString", "internalQueryString", "columns", "responseTimeInMs", "timeFilter", "commands"})
    public ParseQueryOutput(String displayQueryString, String internalQueryString, List<AbstractColumn> columns, Long responseTimeInMs, TimeRange timeFilter, List<AbstractCommandDescriptor> commands) {
        this.displayQueryString = displayQueryString;
        this.internalQueryString = internalQueryString;
        this.columns = columns;
        this.responseTimeInMs = responseTimeInMs;
        this.timeFilter = timeFilter;
        this.commands = commands;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayQueryString() {
        return this.displayQueryString;
    }

    public String getInternalQueryString() {
        return this.internalQueryString;
    }

    public List<AbstractColumn> getColumns() {
        return this.columns;
    }

    public Long getResponseTimeInMs() {
        return this.responseTimeInMs;
    }

    public TimeRange getTimeFilter() {
        return this.timeFilter;
    }

    public List<AbstractCommandDescriptor> getCommands() {
        return this.commands;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParseQueryOutput(");
        sb.append("super=").append(super.toString());
        sb.append("displayQueryString=").append(String.valueOf(this.displayQueryString));
        sb.append(", internalQueryString=").append(String.valueOf(this.internalQueryString));
        sb.append(", columns=").append(String.valueOf(this.columns));
        sb.append(", responseTimeInMs=").append(String.valueOf(this.responseTimeInMs));
        sb.append(", timeFilter=").append(String.valueOf((Object)this.timeFilter));
        sb.append(", commands=").append(String.valueOf(this.commands));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParseQueryOutput)) {
            return false;
        }
        ParseQueryOutput other = (ParseQueryOutput)((Object)o);
        return Objects.equals(this.displayQueryString, other.displayQueryString) && Objects.equals(this.internalQueryString, other.internalQueryString) && Objects.equals(this.columns, other.columns) && Objects.equals(this.responseTimeInMs, other.responseTimeInMs) && Objects.equals((Object)this.timeFilter, (Object)other.timeFilter) && Objects.equals(this.commands, other.commands) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayQueryString == null ? 43 : this.displayQueryString.hashCode());
        result = result * 59 + (this.internalQueryString == null ? 43 : this.internalQueryString.hashCode());
        result = result * 59 + (this.columns == null ? 43 : this.columns.hashCode());
        result = result * 59 + (this.responseTimeInMs == null ? 43 : this.responseTimeInMs.hashCode());
        result = result * 59 + (this.timeFilter == null ? 43 : this.timeFilter.hashCode());
        result = result * 59 + (this.commands == null ? 43 : this.commands.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayQueryString")
        private String displayQueryString;
        @JsonProperty(value="internalQueryString")
        private String internalQueryString;
        @JsonProperty(value="columns")
        private List<AbstractColumn> columns;
        @JsonProperty(value="responseTimeInMs")
        private Long responseTimeInMs;
        @JsonProperty(value="timeFilter")
        private TimeRange timeFilter;
        @JsonProperty(value="commands")
        private List<AbstractCommandDescriptor> commands;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayQueryString(String displayQueryString) {
            this.displayQueryString = displayQueryString;
            this.__explicitlySet__.add("displayQueryString");
            return this;
        }

        public Builder internalQueryString(String internalQueryString) {
            this.internalQueryString = internalQueryString;
            this.__explicitlySet__.add("internalQueryString");
            return this;
        }

        public Builder columns(List<AbstractColumn> columns) {
            this.columns = columns;
            this.__explicitlySet__.add("columns");
            return this;
        }

        public Builder responseTimeInMs(Long responseTimeInMs) {
            this.responseTimeInMs = responseTimeInMs;
            this.__explicitlySet__.add("responseTimeInMs");
            return this;
        }

        public Builder timeFilter(TimeRange timeFilter) {
            this.timeFilter = timeFilter;
            this.__explicitlySet__.add("timeFilter");
            return this;
        }

        public Builder commands(List<AbstractCommandDescriptor> commands) {
            this.commands = commands;
            this.__explicitlySet__.add("commands");
            return this;
        }

        public ParseQueryOutput build() {
            ParseQueryOutput model = new ParseQueryOutput(this.displayQueryString, this.internalQueryString, this.columns, this.responseTimeInMs, this.timeFilter, this.commands);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ParseQueryOutput model) {
            if (model.wasPropertyExplicitlySet("displayQueryString")) {
                this.displayQueryString(model.getDisplayQueryString());
            }
            if (model.wasPropertyExplicitlySet("internalQueryString")) {
                this.internalQueryString(model.getInternalQueryString());
            }
            if (model.wasPropertyExplicitlySet("columns")) {
                this.columns(model.getColumns());
            }
            if (model.wasPropertyExplicitlySet("responseTimeInMs")) {
                this.responseTimeInMs(model.getResponseTimeInMs());
            }
            if (model.wasPropertyExplicitlySet("timeFilter")) {
                this.timeFilter(model.getTimeFilter());
            }
            if (model.wasPropertyExplicitlySet("commands")) {
                this.commands(model.getCommands());
            }
            return this;
        }
    }
}

