/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.loganalytics.model.LogAnalyticsParser;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExtractStructuredLogFieldPathsRequest
extends BmcRequest<LogAnalyticsParser> {
    private String namespaceName;
    private LogAnalyticsParser loganParserDetails;
    private ParserType parserType;
    private String opcRetryToken;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public LogAnalyticsParser getLoganParserDetails() {
        return this.loganParserDetails;
    }

    public ParserType getParserType() {
        return this.parserType;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public LogAnalyticsParser getBody$() {
        return this.loganParserDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).loganParserDetails(this.loganParserDetails).parserType(this.parserType).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",loganParserDetails=").append(String.valueOf((Object)this.loganParserDetails));
        sb.append(",parserType=").append(String.valueOf((Object)this.parserType));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtractStructuredLogFieldPathsRequest)) {
            return false;
        }
        ExtractStructuredLogFieldPathsRequest other = (ExtractStructuredLogFieldPathsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.loganParserDetails, (Object)other.loganParserDetails) && Objects.equals((Object)this.parserType, (Object)other.parserType) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.loganParserDetails == null ? 43 : this.loganParserDetails.hashCode());
        result = result * 59 + (this.parserType == null ? 43 : this.parserType.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ExtractStructuredLogFieldPathsRequest, LogAnalyticsParser> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private LogAnalyticsParser loganParserDetails = null;
        private ParserType parserType = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder loganParserDetails(LogAnalyticsParser loganParserDetails) {
            this.loganParserDetails = loganParserDetails;
            return this;
        }

        public Builder parserType(ParserType parserType) {
            this.parserType = parserType;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExtractStructuredLogFieldPathsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.loganParserDetails(o.getLoganParserDetails());
            this.parserType(o.getParserType());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExtractStructuredLogFieldPathsRequest build() {
            ExtractStructuredLogFieldPathsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(LogAnalyticsParser body) {
            this.loganParserDetails(body);
            return this;
        }

        public ExtractStructuredLogFieldPathsRequest buildWithoutInvocationCallback() {
            ExtractStructuredLogFieldPathsRequest request = new ExtractStructuredLogFieldPathsRequest();
            request.namespaceName = this.namespaceName;
            request.loganParserDetails = this.loganParserDetails;
            request.parserType = this.parserType;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum ParserType implements BmcEnum
    {
        Xml("XML"),
        Json("JSON"),
        Delimited("DELIMITED");

        private final String value;
        private static Map<String, ParserType> map;

        private ParserType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParserType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ParserType: " + key);
        }

        static {
            map = new HashMap<String, ParserType>();
            for (ParserType v : ParserType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

