/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class GetRecalledDataSizeRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String opcRequestId;
    private Date timeDataStarted;
    private Date timeDataEnded;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Date getTimeDataStarted() {
        return this.timeDataStarted;
    }

    public Date getTimeDataEnded() {
        return this.timeDataEnded;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).opcRequestId(this.opcRequestId).timeDataStarted(this.timeDataStarted).timeDataEnded(this.timeDataEnded);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",timeDataStarted=").append(String.valueOf(this.timeDataStarted));
        sb.append(",timeDataEnded=").append(String.valueOf(this.timeDataEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRecalledDataSizeRequest)) {
            return false;
        }
        GetRecalledDataSizeRequest other = (GetRecalledDataSizeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.timeDataStarted, other.timeDataStarted) && Objects.equals(this.timeDataEnded, other.timeDataEnded);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.timeDataStarted == null ? 43 : this.timeDataStarted.hashCode());
        result = result * 59 + (this.timeDataEnded == null ? 43 : this.timeDataEnded.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRecalledDataSizeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String opcRequestId = null;
        private Date timeDataStarted = null;
        private Date timeDataEnded = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder timeDataStarted(Date timeDataStarted) {
            this.timeDataStarted = timeDataStarted;
            return this;
        }

        public Builder timeDataEnded(Date timeDataEnded) {
            this.timeDataEnded = timeDataEnded;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRecalledDataSizeRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.opcRequestId(o.getOpcRequestId());
            this.timeDataStarted(o.getTimeDataStarted());
            this.timeDataEnded(o.getTimeDataEnded());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRecalledDataSizeRequest build() {
            GetRecalledDataSizeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRecalledDataSizeRequest buildWithoutInvocationCallback() {
            GetRecalledDataSizeRequest request = new GetRecalledDataSizeRequest();
            request.namespaceName = this.namespaceName;
            request.opcRequestId = this.opcRequestId;
            request.timeDataStarted = this.timeDataStarted;
            request.timeDataEnded = this.timeDataEnded;
            return request;
        }
    }
}

