/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListOverlappingRecallsRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Date timeDataStarted;
    private Date timeDataEnded;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Date getTimeDataStarted() {
        return this.timeDataStarted;
    }

    public Date getTimeDataEnded() {
        return this.timeDataEnded;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).timeDataStarted(this.timeDataStarted).timeDataEnded(this.timeDataEnded);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",timeDataStarted=").append(String.valueOf(this.timeDataStarted));
        sb.append(",timeDataEnded=").append(String.valueOf(this.timeDataEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListOverlappingRecallsRequest)) {
            return false;
        }
        ListOverlappingRecallsRequest other = (ListOverlappingRecallsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.timeDataStarted, other.timeDataStarted) && Objects.equals(this.timeDataEnded, other.timeDataEnded);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.timeDataStarted == null ? 43 : this.timeDataStarted.hashCode());
        result = result * 59 + (this.timeDataEnded == null ? 43 : this.timeDataEnded.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListOverlappingRecallsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private Date timeDataStarted = null;
        private Date timeDataEnded = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder timeDataStarted(Date timeDataStarted) {
            this.timeDataStarted = timeDataStarted;
            return this;
        }

        public Builder timeDataEnded(Date timeDataEnded) {
            this.timeDataEnded = timeDataEnded;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListOverlappingRecallsRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.timeDataStarted(o.getTimeDataStarted());
            this.timeDataEnded(o.getTimeDataEnded());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListOverlappingRecallsRequest build() {
            ListOverlappingRecallsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListOverlappingRecallsRequest buildWithoutInvocationCallback() {
            ListOverlappingRecallsRequest request = new ListOverlappingRecallsRequest();
            request.namespaceName = this.namespaceName;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.timeDataStarted = this.timeDataStarted;
            request.timeDataEnded = this.timeDataEnded;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeStarted("timeStarted"),
        TimeDataStarted("timeDataStarted");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

