/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.QueryDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class QueryRequest
extends BmcRequest<QueryDetails> {
    private String namespaceName;
    private QueryDetails queryDetails;
    private String page;
    private String opcRequestId;
    private Integer limit;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public QueryDetails getQueryDetails() {
        return this.queryDetails;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    @InternalSdk
    public QueryDetails getBody$() {
        return this.queryDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).queryDetails(this.queryDetails).page(this.page).opcRequestId(this.opcRequestId).limit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",queryDetails=").append(String.valueOf((Object)this.queryDetails));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals((Object)this.queryDetails, (Object)other.queryDetails) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.queryDetails == null ? 43 : this.queryDetails.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<QueryRequest, QueryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private QueryDetails queryDetails = null;
        private String page = null;
        private String opcRequestId = null;
        private Integer limit = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder queryDetails(QueryDetails queryDetails) {
            this.queryDetails = queryDetails;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(QueryRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.queryDetails(o.getQueryDetails());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public QueryRequest build() {
            QueryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(QueryDetails body) {
            this.queryDetails(body);
            return this;
        }

        public QueryRequest buildWithoutInvocationCallback() {
            QueryRequest request = new QueryRequest();
            request.namespaceName = this.namespaceName;
            request.queryDetails = this.queryDetails;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            return request;
        }
    }
}

