/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.loganalytics.model.IngestTimeRule;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateIngestTimeRuleRequest
extends BmcRequest<IngestTimeRule> {
    private String namespaceName;
    private String ingestTimeRuleId;
    private IngestTimeRule updateIngestTimeRuleDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getIngestTimeRuleId() {
        return this.ingestTimeRuleId;
    }

    public IngestTimeRule getUpdateIngestTimeRuleDetails() {
        return this.updateIngestTimeRuleDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public IngestTimeRule getBody$() {
        return this.updateIngestTimeRuleDetails;
    }

    public boolean supportsExpect100Continue() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).ingestTimeRuleId(this.ingestTimeRuleId).updateIngestTimeRuleDetails(this.updateIngestTimeRuleDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",ingestTimeRuleId=").append(String.valueOf(this.ingestTimeRuleId));
        sb.append(",updateIngestTimeRuleDetails=").append(String.valueOf((Object)this.updateIngestTimeRuleDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateIngestTimeRuleRequest)) {
            return false;
        }
        UpdateIngestTimeRuleRequest other = (UpdateIngestTimeRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.ingestTimeRuleId, other.ingestTimeRuleId) && Objects.equals((Object)this.updateIngestTimeRuleDetails, (Object)other.updateIngestTimeRuleDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.ingestTimeRuleId == null ? 43 : this.ingestTimeRuleId.hashCode());
        result = result * 59 + (this.updateIngestTimeRuleDetails == null ? 43 : this.updateIngestTimeRuleDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateIngestTimeRuleRequest, IngestTimeRule> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String ingestTimeRuleId = null;
        private IngestTimeRule updateIngestTimeRuleDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder ingestTimeRuleId(String ingestTimeRuleId) {
            this.ingestTimeRuleId = ingestTimeRuleId;
            return this;
        }

        public Builder updateIngestTimeRuleDetails(IngestTimeRule updateIngestTimeRuleDetails) {
            this.updateIngestTimeRuleDetails = updateIngestTimeRuleDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateIngestTimeRuleRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.ingestTimeRuleId(o.getIngestTimeRuleId());
            this.updateIngestTimeRuleDetails(o.getUpdateIngestTimeRuleDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateIngestTimeRuleRequest build() {
            UpdateIngestTimeRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(IngestTimeRule body) {
            this.updateIngestTimeRuleDetails(body);
            return this;
        }

        public UpdateIngestTimeRuleRequest buildWithoutInvocationCallback() {
            UpdateIngestTimeRuleRequest request = new UpdateIngestTimeRuleRequest();
            request.namespaceName = this.namespaceName;
            request.ingestTimeRuleId = this.ingestTimeRuleId;
            request.updateIngestTimeRuleDetails = this.updateIngestTimeRuleDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

