/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ValidateSourceMappingRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String objectLocation;
    private String filename;
    private String logSourceName;
    private String opcRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getObjectLocation() {
        return this.objectLocation;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getLogSourceName() {
        return this.logSourceName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).objectLocation(this.objectLocation).filename(this.filename).logSourceName(this.logSourceName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",objectLocation=").append(String.valueOf(this.objectLocation));
        sb.append(",filename=").append(String.valueOf(this.filename));
        sb.append(",logSourceName=").append(String.valueOf(this.logSourceName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidateSourceMappingRequest)) {
            return false;
        }
        ValidateSourceMappingRequest other = (ValidateSourceMappingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.objectLocation, other.objectLocation) && Objects.equals(this.filename, other.filename) && Objects.equals(this.logSourceName, other.logSourceName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.objectLocation == null ? 43 : this.objectLocation.hashCode());
        result = result * 59 + (this.filename == null ? 43 : this.filename.hashCode());
        result = result * 59 + (this.logSourceName == null ? 43 : this.logSourceName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ValidateSourceMappingRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String objectLocation = null;
        private String filename = null;
        private String logSourceName = null;
        private String opcRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder objectLocation(String objectLocation) {
            this.objectLocation = objectLocation;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder logSourceName(String logSourceName) {
            this.logSourceName = logSourceName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ValidateSourceMappingRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.objectLocation(o.getObjectLocation());
            this.filename(o.getFilename());
            this.logSourceName(o.getLogSourceName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ValidateSourceMappingRequest build() {
            ValidateSourceMappingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ValidateSourceMappingRequest buildWithoutInvocationCallback() {
            ValidateSourceMappingRequest request = new ValidateSourceMappingRequest();
            request.namespaceName = this.namespaceName;
            request.objectLocation = this.objectLocation;
            request.filename = this.filename;
            request.logSourceName = this.logSourceName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

