/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.responses;

import com.oracle.bmc.loganalytics.model.QueryAggregation;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPageId;
    private String opcPrevPageId;
    private String opcWorkRequestId;
    private String location;
    private QueryAggregation queryAggregation;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPageId() {
        return this.opcNextPageId;
    }

    public String getOpcPrevPageId() {
        return this.opcPrevPageId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public QueryAggregation getQueryAggregation() {
        return this.queryAggregation;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPageId", "opcPrevPageId", "opcWorkRequestId", "location", "queryAggregation"})
    private QueryResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPageId, String opcPrevPageId, String opcWorkRequestId, String location, QueryAggregation queryAggregation) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPageId = opcNextPageId;
        this.opcPrevPageId = opcPrevPageId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.location = location;
        this.queryAggregation = queryAggregation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPageId=").append(String.valueOf(this.opcNextPageId));
        sb.append(",opcPrevPageId=").append(String.valueOf(this.opcPrevPageId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",queryAggregation=").append(String.valueOf((Object)this.queryAggregation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPageId, other.opcNextPageId) && Objects.equals(this.opcPrevPageId, other.opcPrevPageId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.location, other.location) && Objects.equals((Object)this.queryAggregation, (Object)other.queryAggregation);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPageId == null ? 43 : this.opcNextPageId.hashCode());
        result = result * 59 + (this.opcPrevPageId == null ? 43 : this.opcPrevPageId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.queryAggregation == null ? 43 : this.queryAggregation.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<QueryResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPageId;
        private String opcPrevPageId;
        private String opcWorkRequestId;
        private String location;
        private QueryAggregation queryAggregation;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPageId(String opcNextPageId) {
            this.opcNextPageId = opcNextPageId;
            return this;
        }

        public Builder opcPrevPageId(String opcPrevPageId) {
            this.opcPrevPageId = opcPrevPageId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder queryAggregation(QueryAggregation queryAggregation) {
            this.queryAggregation = queryAggregation;
            return this;
        }

        public Builder copy(QueryResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPageId(o.getOpcNextPageId());
            this.opcPrevPageId(o.getOpcPrevPageId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.location(o.getLocation());
            this.queryAggregation(o.getQueryAggregation());
            return this;
        }

        public QueryResponse build() {
            return new QueryResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPageId, this.opcPrevPageId, this.opcWorkRequestId, this.location, this.queryAggregation);
        }
    }
}

