/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.logging.LoggingManagementAsync;
import com.oracle.bmc.logging.internal.http.ChangeLogGroupCompartmentConverter;
import com.oracle.bmc.logging.internal.http.ChangeLogLogGroupConverter;
import com.oracle.bmc.logging.internal.http.ChangeLogSavedSearchCompartmentConverter;
import com.oracle.bmc.logging.internal.http.ChangeUnifiedAgentConfigurationCompartmentConverter;
import com.oracle.bmc.logging.internal.http.CreateLogConverter;
import com.oracle.bmc.logging.internal.http.CreateLogGroupConverter;
import com.oracle.bmc.logging.internal.http.CreateLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.CreateUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.internal.http.DeleteLogConverter;
import com.oracle.bmc.logging.internal.http.DeleteLogGroupConverter;
import com.oracle.bmc.logging.internal.http.DeleteLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.DeleteUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.internal.http.DeleteWorkRequestConverter;
import com.oracle.bmc.logging.internal.http.GetLogConverter;
import com.oracle.bmc.logging.internal.http.GetLogGroupConverter;
import com.oracle.bmc.logging.internal.http.GetLogIncludedSearchConverter;
import com.oracle.bmc.logging.internal.http.GetLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.GetUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.logging.internal.http.ListLogGroupsConverter;
import com.oracle.bmc.logging.internal.http.ListLogIncludedSearchesConverter;
import com.oracle.bmc.logging.internal.http.ListLogSavedSearchesConverter;
import com.oracle.bmc.logging.internal.http.ListLogsConverter;
import com.oracle.bmc.logging.internal.http.ListServicesConverter;
import com.oracle.bmc.logging.internal.http.ListUnifiedAgentConfigurationsConverter;
import com.oracle.bmc.logging.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.logging.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.logging.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.logging.internal.http.UpdateLogConverter;
import com.oracle.bmc.logging.internal.http.UpdateLogGroupConverter;
import com.oracle.bmc.logging.internal.http.UpdateLogSavedSearchConverter;
import com.oracle.bmc.logging.internal.http.UpdateUnifiedAgentConfigurationConverter;
import com.oracle.bmc.logging.requests.ChangeLogGroupCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeLogLogGroupRequest;
import com.oracle.bmc.logging.requests.ChangeLogSavedSearchCompartmentRequest;
import com.oracle.bmc.logging.requests.ChangeUnifiedAgentConfigurationCompartmentRequest;
import com.oracle.bmc.logging.requests.CreateLogGroupRequest;
import com.oracle.bmc.logging.requests.CreateLogRequest;
import com.oracle.bmc.logging.requests.CreateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.CreateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteLogGroupRequest;
import com.oracle.bmc.logging.requests.DeleteLogRequest;
import com.oracle.bmc.logging.requests.DeleteLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.DeleteUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.logging.requests.GetLogGroupRequest;
import com.oracle.bmc.logging.requests.GetLogIncludedSearchRequest;
import com.oracle.bmc.logging.requests.GetLogRequest;
import com.oracle.bmc.logging.requests.GetLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.GetUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.requests.GetWorkRequestRequest;
import com.oracle.bmc.logging.requests.ListLogGroupsRequest;
import com.oracle.bmc.logging.requests.ListLogIncludedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogSavedSearchesRequest;
import com.oracle.bmc.logging.requests.ListLogsRequest;
import com.oracle.bmc.logging.requests.ListServicesRequest;
import com.oracle.bmc.logging.requests.ListUnifiedAgentConfigurationsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.logging.requests.ListWorkRequestsRequest;
import com.oracle.bmc.logging.requests.UpdateLogGroupRequest;
import com.oracle.bmc.logging.requests.UpdateLogRequest;
import com.oracle.bmc.logging.requests.UpdateLogSavedSearchRequest;
import com.oracle.bmc.logging.requests.UpdateUnifiedAgentConfigurationRequest;
import com.oracle.bmc.logging.responses.ChangeLogGroupCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeLogLogGroupResponse;
import com.oracle.bmc.logging.responses.ChangeLogSavedSearchCompartmentResponse;
import com.oracle.bmc.logging.responses.ChangeUnifiedAgentConfigurationCompartmentResponse;
import com.oracle.bmc.logging.responses.CreateLogGroupResponse;
import com.oracle.bmc.logging.responses.CreateLogResponse;
import com.oracle.bmc.logging.responses.CreateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.CreateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteLogGroupResponse;
import com.oracle.bmc.logging.responses.DeleteLogResponse;
import com.oracle.bmc.logging.responses.DeleteLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.DeleteUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.logging.responses.GetLogGroupResponse;
import com.oracle.bmc.logging.responses.GetLogIncludedSearchResponse;
import com.oracle.bmc.logging.responses.GetLogResponse;
import com.oracle.bmc.logging.responses.GetLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.GetUnifiedAgentConfigurationResponse;
import com.oracle.bmc.logging.responses.GetWorkRequestResponse;
import com.oracle.bmc.logging.responses.ListLogGroupsResponse;
import com.oracle.bmc.logging.responses.ListLogIncludedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogSavedSearchesResponse;
import com.oracle.bmc.logging.responses.ListLogsResponse;
import com.oracle.bmc.logging.responses.ListServicesResponse;
import com.oracle.bmc.logging.responses.ListUnifiedAgentConfigurationsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.logging.responses.ListWorkRequestsResponse;
import com.oracle.bmc.logging.responses.UpdateLogGroupResponse;
import com.oracle.bmc.logging.responses.UpdateLogResponse;
import com.oracle.bmc.logging.responses.UpdateLogSavedSearchResponse;
import com.oracle.bmc.logging.responses.UpdateUnifiedAgentConfigurationResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingManagementAsyncClient
implements LoggingManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("LOGGINGMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://logging.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public LoggingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public LoggingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public LoggingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public LoggingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeLogGroupCompartmentResponse> changeLogGroupCompartment(ChangeLogGroupCompartmentRequest request, AsyncHandler<ChangeLogGroupCompartmentRequest, ChangeLogGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeLogGroupCompartment");
        ChangeLogGroupCompartmentRequest interceptedRequest = ChangeLogGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogGroupCompartmentResponse> transformer = ChangeLogGroupCompartmentConverter.fromResponse();
        AsyncHandler<ChangeLogGroupCompartmentRequest, ChangeLogGroupCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeLogGroupCompartmentRequest, ChangeLogGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeLogLogGroupResponse> changeLogLogGroup(ChangeLogLogGroupRequest request, AsyncHandler<ChangeLogLogGroupRequest, ChangeLogLogGroupResponse> handler) {
        LOG.trace("Called async changeLogLogGroup");
        ChangeLogLogGroupRequest interceptedRequest = ChangeLogLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogLogGroupResponse> transformer = ChangeLogLogGroupConverter.fromResponse();
        AsyncHandler<ChangeLogLogGroupRequest, ChangeLogLogGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeLogLogGroupRequest, ChangeLogLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeLogSavedSearchCompartmentResponse> changeLogSavedSearchCompartment(ChangeLogSavedSearchCompartmentRequest request, AsyncHandler<ChangeLogSavedSearchCompartmentRequest, ChangeLogSavedSearchCompartmentResponse> handler) {
        LOG.trace("Called async changeLogSavedSearchCompartment");
        ChangeLogSavedSearchCompartmentRequest interceptedRequest = ChangeLogSavedSearchCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeLogSavedSearchCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeLogSavedSearchCompartmentResponse> transformer = ChangeLogSavedSearchCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeLogSavedSearchCompartmentRequest, ChangeLogSavedSearchCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeLogSavedSearchCompartmentRequest, ChangeLogSavedSearchCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeUnifiedAgentConfigurationCompartmentResponse> changeUnifiedAgentConfigurationCompartment(ChangeUnifiedAgentConfigurationCompartmentRequest request, AsyncHandler<ChangeUnifiedAgentConfigurationCompartmentRequest, ChangeUnifiedAgentConfigurationCompartmentResponse> handler) {
        LOG.trace("Called async changeUnifiedAgentConfigurationCompartment");
        ChangeUnifiedAgentConfigurationCompartmentRequest interceptedRequest = ChangeUnifiedAgentConfigurationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeUnifiedAgentConfigurationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeUnifiedAgentConfigurationCompartmentResponse> transformer = ChangeUnifiedAgentConfigurationCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeUnifiedAgentConfigurationCompartmentRequest, ChangeUnifiedAgentConfigurationCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeUnifiedAgentConfigurationCompartmentRequest, ChangeUnifiedAgentConfigurationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLogResponse> createLog(CreateLogRequest request, AsyncHandler<CreateLogRequest, CreateLogResponse> handler) {
        LOG.trace("Called async createLog");
        CreateLogRequest interceptedRequest = CreateLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogResponse> transformer = CreateLogConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateLogRequest, CreateLogResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLogRequest, CreateLogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLogGroupResponse> createLogGroup(CreateLogGroupRequest request, AsyncHandler<CreateLogGroupRequest, CreateLogGroupResponse> handler) {
        LOG.trace("Called async createLogGroup");
        CreateLogGroupRequest interceptedRequest = CreateLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogGroupResponse> transformer = CreateLogGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateLogGroupRequest, CreateLogGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLogGroupRequest, CreateLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateLogSavedSearchResponse> createLogSavedSearch(CreateLogSavedSearchRequest request, AsyncHandler<CreateLogSavedSearchRequest, CreateLogSavedSearchResponse> handler) {
        LOG.trace("Called async createLogSavedSearch");
        CreateLogSavedSearchRequest interceptedRequest = CreateLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateLogSavedSearchResponse> transformer = CreateLogSavedSearchConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateLogSavedSearchRequest, CreateLogSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateLogSavedSearchRequest, CreateLogSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateUnifiedAgentConfigurationResponse> createUnifiedAgentConfiguration(CreateUnifiedAgentConfigurationRequest request, AsyncHandler<CreateUnifiedAgentConfigurationRequest, CreateUnifiedAgentConfigurationResponse> handler) {
        LOG.trace("Called async createUnifiedAgentConfiguration");
        CreateUnifiedAgentConfigurationRequest interceptedRequest = CreateUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateUnifiedAgentConfigurationResponse> transformer = CreateUnifiedAgentConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateUnifiedAgentConfigurationRequest, CreateUnifiedAgentConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateUnifiedAgentConfigurationRequest, CreateUnifiedAgentConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLogResponse> deleteLog(DeleteLogRequest request, AsyncHandler<DeleteLogRequest, DeleteLogResponse> handler) {
        LOG.trace("Called async deleteLog");
        DeleteLogRequest interceptedRequest = DeleteLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogResponse> transformer = DeleteLogConverter.fromResponse();
        AsyncHandler<DeleteLogRequest, DeleteLogResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLogRequest, DeleteLogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLogGroupResponse> deleteLogGroup(DeleteLogGroupRequest request, AsyncHandler<DeleteLogGroupRequest, DeleteLogGroupResponse> handler) {
        LOG.trace("Called async deleteLogGroup");
        DeleteLogGroupRequest interceptedRequest = DeleteLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogGroupResponse> transformer = DeleteLogGroupConverter.fromResponse();
        AsyncHandler<DeleteLogGroupRequest, DeleteLogGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLogGroupRequest, DeleteLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteLogSavedSearchResponse> deleteLogSavedSearch(DeleteLogSavedSearchRequest request, AsyncHandler<DeleteLogSavedSearchRequest, DeleteLogSavedSearchResponse> handler) {
        LOG.trace("Called async deleteLogSavedSearch");
        DeleteLogSavedSearchRequest interceptedRequest = DeleteLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteLogSavedSearchResponse> transformer = DeleteLogSavedSearchConverter.fromResponse();
        AsyncHandler<DeleteLogSavedSearchRequest, DeleteLogSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteLogSavedSearchRequest, DeleteLogSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteUnifiedAgentConfigurationResponse> deleteUnifiedAgentConfiguration(DeleteUnifiedAgentConfigurationRequest request, AsyncHandler<DeleteUnifiedAgentConfigurationRequest, DeleteUnifiedAgentConfigurationResponse> handler) {
        LOG.trace("Called async deleteUnifiedAgentConfiguration");
        DeleteUnifiedAgentConfigurationRequest interceptedRequest = DeleteUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteUnifiedAgentConfigurationResponse> transformer = DeleteUnifiedAgentConfigurationConverter.fromResponse();
        AsyncHandler<DeleteUnifiedAgentConfigurationRequest, DeleteUnifiedAgentConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteUnifiedAgentConfigurationRequest, DeleteUnifiedAgentConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        LOG.trace("Called async deleteWorkRequest");
        DeleteWorkRequestRequest interceptedRequest = DeleteWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteWorkRequestResponse> transformer = DeleteWorkRequestConverter.fromResponse();
        AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteWorkRequestRequest, DeleteWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogResponse> getLog(GetLogRequest request, AsyncHandler<GetLogRequest, GetLogResponse> handler) {
        LOG.trace("Called async getLog");
        GetLogRequest interceptedRequest = GetLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogResponse> transformer = GetLogConverter.fromResponse();
        AsyncHandler<GetLogRequest, GetLogResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogRequest, GetLogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogGroupResponse> getLogGroup(GetLogGroupRequest request, AsyncHandler<GetLogGroupRequest, GetLogGroupResponse> handler) {
        LOG.trace("Called async getLogGroup");
        GetLogGroupRequest interceptedRequest = GetLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogGroupResponse> transformer = GetLogGroupConverter.fromResponse();
        AsyncHandler<GetLogGroupRequest, GetLogGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogGroupRequest, GetLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogIncludedSearchResponse> getLogIncludedSearch(GetLogIncludedSearchRequest request, AsyncHandler<GetLogIncludedSearchRequest, GetLogIncludedSearchResponse> handler) {
        LOG.trace("Called async getLogIncludedSearch");
        GetLogIncludedSearchRequest interceptedRequest = GetLogIncludedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogIncludedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogIncludedSearchResponse> transformer = GetLogIncludedSearchConverter.fromResponse();
        AsyncHandler<GetLogIncludedSearchRequest, GetLogIncludedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogIncludedSearchRequest, GetLogIncludedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetLogSavedSearchResponse> getLogSavedSearch(GetLogSavedSearchRequest request, AsyncHandler<GetLogSavedSearchRequest, GetLogSavedSearchResponse> handler) {
        LOG.trace("Called async getLogSavedSearch");
        GetLogSavedSearchRequest interceptedRequest = GetLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetLogSavedSearchResponse> transformer = GetLogSavedSearchConverter.fromResponse();
        AsyncHandler<GetLogSavedSearchRequest, GetLogSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetLogSavedSearchRequest, GetLogSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetUnifiedAgentConfigurationResponse> getUnifiedAgentConfiguration(GetUnifiedAgentConfigurationRequest request, AsyncHandler<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse> handler) {
        LOG.trace("Called async getUnifiedAgentConfiguration");
        GetUnifiedAgentConfigurationRequest interceptedRequest = GetUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetUnifiedAgentConfigurationResponse> transformer = GetUnifiedAgentConfigurationConverter.fromResponse();
        AsyncHandler<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetUnifiedAgentConfigurationRequest, GetUnifiedAgentConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogGroupsResponse> listLogGroups(ListLogGroupsRequest request, AsyncHandler<ListLogGroupsRequest, ListLogGroupsResponse> handler) {
        LOG.trace("Called async listLogGroups");
        ListLogGroupsRequest interceptedRequest = ListLogGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogGroupsResponse> transformer = ListLogGroupsConverter.fromResponse();
        AsyncHandler<ListLogGroupsRequest, ListLogGroupsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogGroupsRequest, ListLogGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogIncludedSearchesResponse> listLogIncludedSearches(ListLogIncludedSearchesRequest request, AsyncHandler<ListLogIncludedSearchesRequest, ListLogIncludedSearchesResponse> handler) {
        LOG.trace("Called async listLogIncludedSearches");
        ListLogIncludedSearchesRequest interceptedRequest = ListLogIncludedSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogIncludedSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogIncludedSearchesResponse> transformer = ListLogIncludedSearchesConverter.fromResponse();
        AsyncHandler<ListLogIncludedSearchesRequest, ListLogIncludedSearchesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogIncludedSearchesRequest, ListLogIncludedSearchesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogSavedSearchesResponse> listLogSavedSearches(ListLogSavedSearchesRequest request, AsyncHandler<ListLogSavedSearchesRequest, ListLogSavedSearchesResponse> handler) {
        LOG.trace("Called async listLogSavedSearches");
        ListLogSavedSearchesRequest interceptedRequest = ListLogSavedSearchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogSavedSearchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogSavedSearchesResponse> transformer = ListLogSavedSearchesConverter.fromResponse();
        AsyncHandler<ListLogSavedSearchesRequest, ListLogSavedSearchesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogSavedSearchesRequest, ListLogSavedSearchesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListLogsResponse> listLogs(ListLogsRequest request, AsyncHandler<ListLogsRequest, ListLogsResponse> handler) {
        LOG.trace("Called async listLogs");
        ListLogsRequest interceptedRequest = ListLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListLogsResponse> transformer = ListLogsConverter.fromResponse();
        AsyncHandler<ListLogsRequest, ListLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListLogsRequest, ListLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListServicesResponse> listServices(ListServicesRequest request, AsyncHandler<ListServicesRequest, ListServicesResponse> handler) {
        LOG.trace("Called async listServices");
        ListServicesRequest interceptedRequest = ListServicesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListServicesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListServicesResponse> transformer = ListServicesConverter.fromResponse();
        AsyncHandler<ListServicesRequest, ListServicesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListServicesRequest, ListServicesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListUnifiedAgentConfigurationsResponse> listUnifiedAgentConfigurations(ListUnifiedAgentConfigurationsRequest request, AsyncHandler<ListUnifiedAgentConfigurationsRequest, ListUnifiedAgentConfigurationsResponse> handler) {
        LOG.trace("Called async listUnifiedAgentConfigurations");
        ListUnifiedAgentConfigurationsRequest interceptedRequest = ListUnifiedAgentConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListUnifiedAgentConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListUnifiedAgentConfigurationsResponse> transformer = ListUnifiedAgentConfigurationsConverter.fromResponse();
        AsyncHandler<ListUnifiedAgentConfigurationsRequest, ListUnifiedAgentConfigurationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListUnifiedAgentConfigurationsRequest, ListUnifiedAgentConfigurationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLogResponse> updateLog(UpdateLogRequest request, AsyncHandler<UpdateLogRequest, UpdateLogResponse> handler) {
        LOG.trace("Called async updateLog");
        UpdateLogRequest interceptedRequest = UpdateLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogResponse> transformer = UpdateLogConverter.fromResponse();
        AsyncHandler<UpdateLogRequest, UpdateLogResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLogRequest, UpdateLogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLogGroupResponse> updateLogGroup(UpdateLogGroupRequest request, AsyncHandler<UpdateLogGroupRequest, UpdateLogGroupResponse> handler) {
        LOG.trace("Called async updateLogGroup");
        UpdateLogGroupRequest interceptedRequest = UpdateLogGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogGroupResponse> transformer = UpdateLogGroupConverter.fromResponse();
        AsyncHandler<UpdateLogGroupRequest, UpdateLogGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLogGroupRequest, UpdateLogGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateLogSavedSearchResponse> updateLogSavedSearch(UpdateLogSavedSearchRequest request, AsyncHandler<UpdateLogSavedSearchRequest, UpdateLogSavedSearchResponse> handler) {
        LOG.trace("Called async updateLogSavedSearch");
        UpdateLogSavedSearchRequest interceptedRequest = UpdateLogSavedSearchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateLogSavedSearchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateLogSavedSearchResponse> transformer = UpdateLogSavedSearchConverter.fromResponse();
        AsyncHandler<UpdateLogSavedSearchRequest, UpdateLogSavedSearchResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateLogSavedSearchRequest, UpdateLogSavedSearchResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateUnifiedAgentConfigurationResponse> updateUnifiedAgentConfiguration(UpdateUnifiedAgentConfigurationRequest request, AsyncHandler<UpdateUnifiedAgentConfigurationRequest, UpdateUnifiedAgentConfigurationResponse> handler) {
        LOG.trace("Called async updateUnifiedAgentConfiguration");
        UpdateUnifiedAgentConfigurationRequest interceptedRequest = UpdateUnifiedAgentConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateUnifiedAgentConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateUnifiedAgentConfigurationResponse> transformer = UpdateUnifiedAgentConfigurationConverter.fromResponse();
        AsyncHandler<UpdateUnifiedAgentConfigurationRequest, UpdateUnifiedAgentConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateUnifiedAgentConfigurationRequest, UpdateUnifiedAgentConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, LoggingManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public LoggingManagementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new LoggingManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

