/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.logging.model.UnifiedAgentParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="parserType")
@JsonFilter(value="explicitlySetFilter")
public final class UnifiedJSONParser
extends UnifiedAgentParser {
    @JsonProperty(value="timeType")
    private final TimeType timeType;
    @JsonProperty(value="timeFormat")
    private final String timeFormat;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public UnifiedJSONParser(String fieldTimeKey, Map<String, String> types, String nullValuePattern, Boolean isNullEmptyString, Boolean isEstimateCurrentEvent, Boolean isKeepTimeKey, Integer timeoutInMilliseconds, TimeType timeType, String timeFormat) {
        super(fieldTimeKey, types, nullValuePattern, isNullEmptyString, isEstimateCurrentEvent, isKeepTimeKey, timeoutInMilliseconds);
        this.timeType = timeType;
        this.timeFormat = timeFormat;
    }

    public Builder toBuilder() {
        return new Builder().timeType(this.timeType).timeFormat(this.timeFormat);
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "UnifiedJSONParser(super=" + super.toString() + ", timeType=" + (Object)((Object)this.getTimeType()) + ", timeFormat=" + this.getTimeFormat() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnifiedJSONParser)) {
            return false;
        }
        UnifiedJSONParser other = (UnifiedJSONParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeType this$timeType = this.getTimeType();
        TimeType other$timeType = other.getTimeType();
        if (this$timeType == null ? other$timeType != null : !((Object)((Object)this$timeType)).equals((Object)other$timeType)) {
            return false;
        }
        String this$timeFormat = this.getTimeFormat();
        String other$timeFormat = other.getTimeFormat();
        if (this$timeFormat == null ? other$timeFormat != null : !this$timeFormat.equals(other$timeFormat)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnifiedJSONParser;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TimeType $timeType = this.getTimeType();
        result = result * 59 + ($timeType == null ? 43 : ((Object)((Object)$timeType)).hashCode());
        String $timeFormat = this.getTimeFormat();
        result = result * 59 + ($timeFormat == null ? 43 : $timeFormat.hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum TimeType {
        Float("FLOAT"),
        Unixtime("UNIXTIME"),
        String("STRING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TimeType> map;

        private TimeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TimeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TimeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TimeType.class);
            map = new HashMap<String, TimeType>();
            for (TimeType v : TimeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldTimeKey")
        private String fieldTimeKey;
        @JsonProperty(value="types")
        private Map<String, String> types;
        @JsonProperty(value="nullValuePattern")
        private String nullValuePattern;
        @JsonProperty(value="isNullEmptyString")
        private Boolean isNullEmptyString;
        @JsonProperty(value="isEstimateCurrentEvent")
        private Boolean isEstimateCurrentEvent;
        @JsonProperty(value="isKeepTimeKey")
        private Boolean isKeepTimeKey;
        @JsonProperty(value="timeoutInMilliseconds")
        private Integer timeoutInMilliseconds;
        @JsonProperty(value="timeType")
        private TimeType timeType;
        @JsonProperty(value="timeFormat")
        private String timeFormat;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldTimeKey(String fieldTimeKey) {
            this.fieldTimeKey = fieldTimeKey;
            this.__explicitlySet__.add("fieldTimeKey");
            return this;
        }

        public Builder types(Map<String, String> types) {
            this.types = types;
            this.__explicitlySet__.add("types");
            return this;
        }

        public Builder nullValuePattern(String nullValuePattern) {
            this.nullValuePattern = nullValuePattern;
            this.__explicitlySet__.add("nullValuePattern");
            return this;
        }

        public Builder isNullEmptyString(Boolean isNullEmptyString) {
            this.isNullEmptyString = isNullEmptyString;
            this.__explicitlySet__.add("isNullEmptyString");
            return this;
        }

        public Builder isEstimateCurrentEvent(Boolean isEstimateCurrentEvent) {
            this.isEstimateCurrentEvent = isEstimateCurrentEvent;
            this.__explicitlySet__.add("isEstimateCurrentEvent");
            return this;
        }

        public Builder isKeepTimeKey(Boolean isKeepTimeKey) {
            this.isKeepTimeKey = isKeepTimeKey;
            this.__explicitlySet__.add("isKeepTimeKey");
            return this;
        }

        public Builder timeoutInMilliseconds(Integer timeoutInMilliseconds) {
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.__explicitlySet__.add("timeoutInMilliseconds");
            return this;
        }

        public Builder timeType(TimeType timeType) {
            this.timeType = timeType;
            this.__explicitlySet__.add("timeType");
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            this.__explicitlySet__.add("timeFormat");
            return this;
        }

        public UnifiedJSONParser build() {
            UnifiedJSONParser __instance__ = new UnifiedJSONParser(this.fieldTimeKey, this.types, this.nullValuePattern, this.isNullEmptyString, this.isEstimateCurrentEvent, this.isKeepTimeKey, this.timeoutInMilliseconds, this.timeType, this.timeFormat);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(UnifiedJSONParser o) {
            Builder copiedBuilder = this.fieldTimeKey(o.getFieldTimeKey()).types(o.getTypes()).nullValuePattern(o.getNullValuePattern()).isNullEmptyString(o.getIsNullEmptyString()).isEstimateCurrentEvent(o.getIsEstimateCurrentEvent()).isKeepTimeKey(o.getIsKeepTimeKey()).timeoutInMilliseconds(o.getTimeoutInMilliseconds()).timeType(o.getTimeType()).timeFormat(o.getTimeFormat());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "UnifiedJSONParser.Builder(timeType=" + (Object)((Object)this.timeType) + ", timeFormat=" + this.timeFormat + ")";
        }
    }
}

