/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.logging.model.CreateLogDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateLogRequest
extends BmcRequest<CreateLogDetails> {
    private String logGroupId;
    private CreateLogDetails createLogDetails;
    private String opcRetryToken;
    private String opcRequestId;

    @InternalSdk
    public CreateLogDetails getBody$() {
        return this.createLogDetails;
    }

    @ConstructorProperties(value={"logGroupId", "createLogDetails", "opcRetryToken", "opcRequestId"})
    CreateLogRequest(String logGroupId, CreateLogDetails createLogDetails, String opcRetryToken, String opcRequestId) {
        this.logGroupId = logGroupId;
        this.createLogDetails = createLogDetails;
        this.opcRetryToken = opcRetryToken;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLogGroupId() {
        return this.logGroupId;
    }

    public CreateLogDetails getCreateLogDetails() {
        return this.createLogDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateLogRequest, CreateLogDetails> {
        private String logGroupId;
        private CreateLogDetails createLogDetails;
        private String opcRetryToken;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateLogRequest o) {
            this.logGroupId(o.getLogGroupId());
            this.createLogDetails(o.getCreateLogDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateLogRequest build() {
            CreateLogRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateLogDetails body) {
            this.createLogDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder logGroupId(String logGroupId) {
            this.logGroupId = logGroupId;
            return this;
        }

        public Builder createLogDetails(CreateLogDetails createLogDetails) {
            this.createLogDetails = createLogDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CreateLogRequest buildWithoutInvocationCallback() {
            return new CreateLogRequest(this.logGroupId, this.createLogDetails, this.opcRetryToken, this.opcRequestId);
        }

        public String toString() {
            return "CreateLogRequest.Builder(logGroupId=" + this.logGroupId + ", createLogDetails=" + this.createLogDetails + ", opcRetryToken=" + this.opcRetryToken + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

