/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.logging.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetLogIncludedSearchRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String logIncludedSearchId;
    private String opcRequestId;

    @ConstructorProperties(value={"compartmentId", "logIncludedSearchId", "opcRequestId"})
    GetLogIncludedSearchRequest(String compartmentId, String logIncludedSearchId, String opcRequestId) {
        this.compartmentId = compartmentId;
        this.logIncludedSearchId = logIncludedSearchId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getLogIncludedSearchId() {
        return this.logIncludedSearchId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLogIncludedSearchRequest, Void> {
        private String compartmentId;
        private String logIncludedSearchId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLogIncludedSearchRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.logIncludedSearchId(o.getLogIncludedSearchId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLogIncludedSearchRequest build() {
            GetLogIncludedSearchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder logIncludedSearchId(String logIncludedSearchId) {
            this.logIncludedSearchId = logIncludedSearchId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetLogIncludedSearchRequest buildWithoutInvocationCallback() {
            return new GetLogIncludedSearchRequest(this.compartmentId, this.logIncludedSearchId, this.opcRequestId);
        }

        public String toString() {
            return "GetLogIncludedSearchRequest.Builder(compartmentId=" + this.compartmentId + ", logIncludedSearchId=" + this.logIncludedSearchId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

